package org.dromara.zjk.domain.vo;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.dromara.common.sensitive.annotation.Sensitive;
import org.dromara.common.sensitive.core.SensitiveStrategy;
import org.dromara.zjk.zwy.annotation.EncryptSensitive;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serial;
import java.io.Serializable;
import java.util.Date;
import java.util.List;


/**
 * 专家抽取视图对象 zjk_item_extreation
 *
 * @author ygh
 * @date 2024-10-29
 */
@Data
public class ZjkReviewProductVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 专家id
     */
    private Long expertId;

    /**
     * 项目阶段
     */
    private String reviewSn;

    /**
     * 评审时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date reviewTime;

    /**
     * 规则id
     */
    private String reviewId;

    private List<ZjkReviewPhaseVo> phaseVoList;

    /**
     * 项目名称
     */
    @ExcelProperty(value = "项目编号")
    private String productSn;

    /**
     * 项目名称
     */
    @ExcelProperty(value = "项目名称")
    private String productName;

    /**
     * 项目类型
     */
    @ExcelProperty(value = "项目类型")
    private String productType;

    /**
     * 项目规则
     */
    @ExcelProperty(value = "项目规模")
    private Integer productScale;

    /**
     * 项目单位
     */
    @ExcelProperty(value = "项目单位")
    private String productUnit;

    /**
     * 联系人
     */
    @ExcelProperty(value = "联系人")
    private String unitBy;

    /**
     * 联系方式
     */

    @EncryptSensitive
    @ExcelProperty(value = "联系方式")
    private String unitConcat;

    /**
     *  简介
     */
    @ExcelProperty(value = "简介")
    private String productBrief;

    /**
     * 状态名称
     */
    @ExcelIgnore
    private String productDataUrl;

    /**
     * 状态
     */
    private Long status;

    /**
     * 备注
     */
    @ExcelProperty(value = "备注")
    private String remark;

    private Long productId;


    //private String productName;
    //private String productSn;
    //private String productUnit;
    //private String unitBy;
    //private String unitConcat;
    //private String reviewSn;
    //private String reviewTime;


}
