package org.dromara.zjk.learning_world.domain.excel;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import org.dromara.zjk.learning_world.domain.entity.ZjkLearningCourse;

import java.io.Serial;
import java.io.Serializable;


/**
 * 课程视图对象 zjk_learning_course
 *
 * @author ygh
 * @date 2024-11-08
 */
@Data
public class ZjkLearningCourseExcel   {

    /**
     * 课程名称
     */
    @ExcelProperty(value = "课程名称")
    private String courseName;

    /**
     * 课程分类
     */
    @ExcelIgnore
    private String courseClassify;
    /**
     * 课程分类
     */
    @ExcelProperty(value = "课程分类")
    private String courseClassifyName;

    /**
     * 授课方式
     */
    @ExcelIgnore
    private String teachingType;
    /**
     * 授课方式
     */
    @ExcelProperty(value = "授课方式")
    private String teachingTypeName;

    /**
     * 课程简介
     */
    @ExcelProperty(value = "课程简介")
    private String courseBrief;

    /**
     * 课程图片
     */
    @ExcelProperty(value = "课程图片")
    private String coursePic;

    /**
     * 状态
     */
    @ExcelIgnore
    private String status;

    /**
     * 状态
     */
    @ExcelProperty(value = "状态")
    private String statusName;


    /**
     * 备注
     */
    @ExcelProperty(value = "备注")
    private String remark;



}
