package org.dromara.zjk.utils;

import lombok.extern.slf4j.Slf4j;

import java.time.LocalDate;
import java.time.Period;
import java.time.format.DateTimeFormatter;

@Slf4j
public class IdCardUtils {


    // 根据身份证号计算年龄并判断是否小于65岁
    public static boolean isAgeUnder65(String idCard) {
        if (idCard == null || idCard.length() != 18) {
            log.error("当前身份证号格式不正常:"+idCard);
            return false;
        }
        // 提取身份证号中的出生日期（假设身份证号为18位）
        String birthDateStr = idCard.substring(6, 14);
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        LocalDate birthDate = LocalDate.parse(birthDateStr, dateFormatter);
        // 计算年龄
        LocalDate currentDate = LocalDate.now();
        int age = Period.between(birthDate, currentDate).getYears();
        // 返回年龄是否小于65岁
        return age < 65;
    }
}
