/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.license.utils;

import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.apps.StatefulSet;
import io.fabric8.kubernetes.api.model.apps.StatefulSetList;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class K8sEnvUtil {
    private static final Logger a = Logger.getLogger(K8sEnvUtil.class.getName());
    private static KubernetesClient b;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static KubernetesClient a() {
        if (b != null) return b;
        Class<K8sEnvUtil> clazz = K8sEnvUtil.class;
        synchronized (K8sEnvUtil.class) {
            if (b != null) return b;
            b = new DefaultKubernetesClient();
            // ** MonitorExit[var0] (shouldn't be in output)
            return b;
        }
    }

    public static String getNameSpace() {
        String string = K8sEnvUtil.a().getNamespace();
        if (a.isLoggable(Level.FINE)) {
            a.fine("nameSpace: " + string);
        }
        return string;
    }

    public static String getServiceName() {
        try {
            String[] stringArray = InetAddress.getLocalHost().toString().split("-");
            if (stringArray.length > 1) {
                if (a.isLoggable(Level.FINE)) {
                    a.fine("serviceName: " + stringArray[0]);
                }
                return stringArray[0];
            }
            return "";
        }
        catch (Exception exception) {
            a.warning("Can not get k8s env info " + exception.getMessage());
            return "";
        }
    }

    public static String getPodServerName() {
        try {
            return InetAddress.getLocalHost().toString().split("\\.")[0];
        }
        catch (UnknownHostException unknownHostException) {
            throw new RuntimeException("Load host name failed. " + unknownHostException.getMessage());
        }
    }

    public static Service getService() {
        return (Service)((ServiceResource)((NonNamespaceOperation)K8sEnvUtil.a().services().inNamespace(K8sEnvUtil.getNameSpace())).withName(K8sEnvUtil.getServiceName())).get();
    }

    public static Pod getPod() {
        return (Pod)((PodResource)((NonNamespaceOperation)K8sEnvUtil.a().pods().inNamespace(K8sEnvUtil.getNameSpace())).withName(K8sEnvUtil.getPodServerName())).get();
    }

    public static String getPodImageId() {
        try {
            return ((ContainerStatus)K8sEnvUtil.getPod().getStatus().getContainerStatuses().get(0)).getImageID();
        }
        catch (Exception exception) {
            if (a.isLoggable(Level.FINE)) {
                a.fine("Can not get k8s env info " + exception.getMessage());
            }
            return "";
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isRunningInDocker() {
        if (K8sEnvUtil.a.isLoggable(Level.FINE)) {
            K8sEnvUtil.a.fine("-----------------isRunningInDocker--------------------");
        }
        var0 = new File("/proc/1/cgroup");
        try {
            block15: {
                block14: {
                    var0 = new BufferedReader(new FileReader((File)var0));
                    var1_4 = null;
                    try {
                        var2_5 = new StringBuilder();
                        while ((var3_7 = var0.readLine()) != null) {
                            var2_5.append(var3_7);
                            if (!var3_7.contains("docker") || var3_7.contains("kubepods")) continue;
                            if (K8sEnvUtil.a.isLoggable(Level.FINE)) {
                                K8sEnvUtil.a.fine("isRunningInDocker : true");
                            }
                            break block14;
                        }
                        ** GOTO lbl-1000
                    }
                    catch (Throwable v0) {
                        try {
                            var2_5 = v0;
                            var1_4 = v0;
                            throw var2_5;
                        }
                        catch (Throwable var2_6) {
                            if (var1_4 == null) {
                                var0.close();
                                throw var2_6;
                            }
                            try {
                                var0.close();
                                throw var2_6;
                            }
                            catch (Throwable var0_1) {
                                var1_4.addSuppressed(var0_1);
                                throw var2_6;
                            }
                        }
                    }
                }
                var0.close();
                return true;
lbl-1000:
                // 1 sources

                {
                    if (!K8sEnvUtil.a.isLoggable(Level.FINE)) break block15;
                    K8sEnvUtil.a.fine("isRunningInDocker : false, content line " + var3_7);
                }
            }
            var0.close();
            return false;
        }
        catch (FileNotFoundException var0_2) {
            if (K8sEnvUtil.a.isLoggable(Level.FINE) == false) return false;
            K8sEnvUtil.a.fine("isRunningInDocker : false  " + var0_2.getMessage());
            return false;
        }
        catch (IOException var0_3) {
            throw new RuntimeException("Read cgroup failed. " + var0_3.getMessage());
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isRunningInK8s() {
        if (K8sEnvUtil.a.isLoggable(Level.FINE)) {
            K8sEnvUtil.a.fine("-----------------isRunningInK8s--------------------");
        }
        var0 = new File("/proc/1/cgroup");
        try {
            block15: {
                block14: {
                    var0 = new BufferedReader(new FileReader((File)var0));
                    var1_3 = null;
                    try {
                        var2_4 = new StringBuilder();
                        while ((var3_6 = var0.readLine()) != null) {
                            var2_4.append(var3_6);
                            if (!var3_6.contains("kubepods")) continue;
                            if (K8sEnvUtil.a.isLoggable(Level.FINE)) {
                                K8sEnvUtil.a.fine("isRunningInK8s : true");
                            }
                            break block14;
                        }
                        ** GOTO lbl-1000
                    }
                    catch (Throwable v0) {
                        try {
                            var2_4 = v0;
                            var1_3 = v0;
                            throw var2_4;
                        }
                        catch (Throwable var2_5) {
                            if (var1_3 == null) {
                                var0.close();
                                throw var2_5;
                            }
                            try {
                                var0.close();
                                throw var2_5;
                            }
                            catch (Throwable var0_1) {
                                var1_3.addSuppressed(var0_1);
                                throw var2_5;
                            }
                        }
                    }
                }
                var0.close();
                return true;
lbl-1000:
                // 1 sources

                {
                    if (!K8sEnvUtil.a.isLoggable(Level.FINE)) break block15;
                    K8sEnvUtil.a.fine("isRunningInK8s : false, content line " + var3_6);
                }
            }
            var0.close();
            return false;
        }
        catch (FileNotFoundException v1) {
            return false;
        }
        catch (IOException var0_2) {
            throw new RuntimeException("Read cgroup failed. " + var0_2.getMessage());
        }
    }

    public static StatefulSet getStateFulSet() {
        StatefulSet statefulSet;
        Iterator iterator;
        if (a.isLoggable(Level.FINE)) {
            a.fine("-----------------getStateFulSet--------------------");
        }
        if (a.isLoggable(Level.FINE)) {
            iterator = ((StatefulSetList)((NonNamespaceOperation)K8sEnvUtil.a().apps().statefulSets().inNamespace(K8sEnvUtil.getNameSpace())).list()).getItems();
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                statefulSet = (StatefulSet)iterator.next();
                a.fine("statefulSet name: " + statefulSet.getMetadata().getName());
            }
        }
        try {
            iterator = ((StatefulSetList)((NonNamespaceOperation)K8sEnvUtil.a().apps().statefulSets().inNamespace(K8sEnvUtil.getNameSpace())).list()).getItems();
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                statefulSet = (StatefulSet)iterator.next();
                if (!statefulSet.getMetadata().getName().startsWith(K8sEnvUtil.getServiceName())) continue;
                return statefulSet;
            }
        }
        catch (Exception exception) {
            iterator = exception;
            exception.printStackTrace();
        }
        return null;
    }
}

