/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.webresources;

import com.tongweb.container.WebResource;
import com.tongweb.container.WebResourceRoot;
import com.tongweb.container.webresources.TrackedInputStream;
import com.tongweb.juli.logging.Log;
import com.tongweb.web.util.http.FastHttpDateFormat;
import com.tongweb.web.util.res.StringManager;
import java.io.InputStream;

public abstract class AbstractResource
implements WebResource {
    protected static final StringManager sm = StringManager.getManager(AbstractResource.class);
    private final WebResourceRoot root;
    private final String webAppPath;
    private String mimeType = null;
    private volatile String weakETag;

    protected AbstractResource(WebResourceRoot root, String webAppPath) {
        this.root = root;
        this.webAppPath = webAppPath;
    }

    @Override
    public final WebResourceRoot getWebResourceRoot() {
        return this.root;
    }

    @Override
    public final String getWebappPath() {
        return this.webAppPath;
    }

    @Override
    public final String getLastModifiedHttp() {
        return FastHttpDateFormat.formatDate(this.getLastModified());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String getETag() {
        if (this.weakETag == null) {
            AbstractResource abstractResource = this;
            synchronized (abstractResource) {
                if (this.weakETag == null) {
                    long contentLength = this.getContentLength();
                    long lastModified = this.getLastModified();
                    if (contentLength >= 0L || lastModified >= 0L) {
                        this.weakETag = "W/\"" + contentLength + "-" + lastModified + "\"";
                    }
                }
            }
        }
        return this.weakETag;
    }

    @Override
    public final void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    @Override
    public final String getMimeType() {
        return this.mimeType;
    }

    @Override
    public final InputStream getInputStream() {
        InputStream is = this.doGetInputStream();
        if (is == null || !this.root.getTrackLockedFiles()) {
            return is;
        }
        return new TrackedInputStream(this.root, this.getName(), is);
    }

    protected abstract InputStream doGetInputStream();

    protected abstract Log getLog();
}

