/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.remote.grpc;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.remote.request.Request;
import com.alibaba.nacos.api.remote.request.RequestMeta;
import com.alibaba.nacos.api.remote.response.Response;
import com.alibaba.nacos.common.paramcheck.AbstractParamChecker;
import com.alibaba.nacos.common.paramcheck.ParamCheckResponse;
import com.alibaba.nacos.common.paramcheck.ParamCheckerManager;
import com.alibaba.nacos.common.paramcheck.ParamInfo;
import com.alibaba.nacos.core.paramcheck.AbstractRpcParamExtractor;
import com.alibaba.nacos.core.paramcheck.ExtractorManager;
import com.alibaba.nacos.core.paramcheck.ServerParamCheckConfig;
import com.alibaba.nacos.core.remote.AbstractRequestFilter;
import com.alibaba.nacos.plugin.control.Loggers;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class RemoteParamCheckFilter
extends AbstractRequestFilter {
    @Override
    protected Response filter(Request request, RequestMeta meta, Class handlerClazz) throws NacosException {
        boolean paramCheckEnabled = ServerParamCheckConfig.getInstance().isParamCheckEnabled();
        if (!paramCheckEnabled) {
            return null;
        }
        try {
            ExtractorManager.Extractor extractor = this.getHandleMethod(handlerClazz).getAnnotation(ExtractorManager.Extractor.class);
            if (extractor == null && (extractor = handlerClazz.getAnnotation(ExtractorManager.Extractor.class)) == null) {
                return null;
            }
            AbstractRpcParamExtractor paramExtractor = ExtractorManager.getRpcExtractor(extractor);
            List<ParamInfo> paramInfoList = paramExtractor.extractParam(request);
            ParamCheckerManager paramCheckerManager = ParamCheckerManager.getInstance();
            AbstractParamChecker paramChecker = paramCheckerManager.getParamChecker(ServerParamCheckConfig.getInstance().getActiveParamChecker());
            ParamCheckResponse checkResponse = paramChecker.checkParamInfoList(paramInfoList);
            if (!checkResponse.isSuccess()) {
                return this.generateFailResponse(request, checkResponse.getMessage(), handlerClazz);
            }
        }
        catch (Exception e) {
            return this.generateFailResponse(request, e.getMessage(), handlerClazz);
        }
        return null;
    }

    private Response generateFailResponse(Request request, String message, Class handlerClazz) {
        try {
            Response response = super.getDefaultResponseInstance(handlerClazz);
            response.setErrorInfo(400, "Param check invalid:" + message);
            Loggers.CONTROL.info("Param check invalid,{},request:{}:", (Object)message, (Object)request.getClass().getSimpleName());
            return response;
        }
        catch (Exception e) {
            Loggers.CONTROL.error("Param check fail ,request:{}", (Object)request.getClass().getSimpleName(), (Object)e);
            return null;
        }
    }
}

