# 专家抽取模块详细设计文档

## 模块1：`专家抽取条件管理`

### 功能描述
提供多维度的专家抽取条件设置，支持查询、新增、修改和删除抽取条件，并能根据条件筛选出符合要求的专家信息。

### 输入/输出
- **输入**:
    - 抽取条件业务对象 [ZjkReviewPhaseBo](file://D:\jyh-zjk\ruoyi-modules\zjk-api\src\main\java\org\dromara\zjk\domain\bo\ZjkReviewPhaseBo.java#L16-L65)
    - 分页查询对象 [PageQuery](file://D:\jyh-zjk\ruoyi-common\ruoyi-common-mybatis\src\main\java\org\dromara\common\mybatis\core\page\PageQuery.java#L22-L121)
- **输出**:
    - 包含抽取条件信息的 [ZjkReviewPhaseVo](file://D:\jyh-zjk\ruoyi-modules\zjk-api\src\main\java\org\dromara\zjk\domain\vo\ZjkReviewPhaseVo.java#L14-L63)

### 处理逻辑
```java
// 查询抽取条件列表
@GetMapping("/list")
public TableDataInfo<ZjkReviewPhaseVo> list(ZjkReviewPhaseBo bo, PageQuery pageQuery) {
    return zjkReviewPhaseService.queryPageList(bo, pageQuery);
}

// 新增抽取条件
@PostMapping()
public R<Void> add(@Validated(AddGroup.class) @RequestBody ZjkReviewPhaseBo bo) {
    return toAjax(zjkReviewPhaseService.insertByBo(bo));
}

// 修改抽取条件
@PutMapping()
public R<Void> edit(@Validated(EditGroup.class) @RequestBody ZjkReviewPhaseBo bo) {
    return toAjax(zjkReviewPhaseService.updateByBo(bo));
}

// 删除抽取条件
@DeleteMapping("/{tenantIds}")
public R<Void> remove(@NotEmpty(message = "主键不能为空")
                      @PathVariable String[] tenantIds) {
    return toAjax(zjkReviewPhaseService.deleteWithValidByIds(List.of(tenantIds), true));
}
```


### 接口定义
- **API签名**:
    - `GET /reviewPhase/list`
    - `POST /reviewPhase`
    - `PUT /reviewPhase`
    - `DELETE /reviewPhase/{tenantIds}`
- **消息格式**: JSON
- **示例响应**:
```json
{
  "code": 200,
  "msg": "success",
  "data": {
    "total": 10,
    "rows": [
      {
        "conditionName": "高级职称",
        "description": "筛选具有高级职称的专家"
      }
    ]
  }
}
```


---

## 模块2：`评审项目与抽取记录管理`

### 功能描述
管理与抽取条件关联的评审项目信息，支持项目的查询、导出以及通过规则查询抽取记录。同时提供统计分析功能。

### 输入/输出
- **输入**:
    - 评审项目业务对象 [ZjkReviewProductBo](file://D:\jyh-zjk\ruoyi-modules\zjk-api\src\main\java\org\dromara\zjk\domain\bo\ZjkReviewProductBo.java#L16-L69)
    - 分页查询对象 [PageQuery](file://D:\jyh-zjk\ruoyi-common\ruoyi-common-mybatis\src\main\java\org\dromara\common\mybatis\core\page\PageQuery.java#L22-L121)
- **输出**:
    - 包含评审项目信息的 [ZjkReviewProductVo](file://D:\jyh-zjk\ruoyi-modules\zjk-api\src\main\java\org\dromara\zjk\domain\vo\ZjkReviewProductVo.java#L14-L62)
    - 导出数据封装类 [ZjkReviewExportVo](file://D:\jyh-zjk\ruoyi-modules\zjk-api\src\main\java\org\dromara\zjk\domain\vo\ZjkReviewExportVo.java#L15-L20)

### 处理逻辑
```java
// 查询评审项目列表
@GetMapping("/review/product/list")
public TableDataInfo<ZjkReviewProductVo> reviewProductList(ZjkReviewProductBo bo, PageQuery pageQuery) {
    return zjkReviewPhaseService.reviewProductList(bo, pageQuery);
}

// 导出评审项目列表
@PostMapping("/review/export")
public void reviewExport(ZjkReviewProductBo bo, HttpServletResponse response) {
    List<ZjkReviewProductVo> zjkReviewProductVos = zjkReviewPhaseService.reviewExport(bo);
    List<ZjkReviewExportVo> zjkReviewExportVo = BeanUtil.copyToList(zjkReviewProductVos, ZjkReviewExportVo.class);
    ExcelUtil.exportExcel(zjkReviewExportVo, "评审项目", ZjkReviewExportVo.class, response);
}

// 获取单个评审项目详细信息
@GetMapping("/getInfo/{productId}")
public R<ZjkReviewProductVo> getInfo(@NotNull(message = "项目id不能为空")
                                     @PathVariable Long productId) {
    ZjkReviewProductVo zjkReviewProductVos = zjkReviewPhaseService.reviewListById(productId);
    return R.ok(zjkReviewProductVos);
}
```


### 接口定义
- **API签名**:
    - `GET /reviewPhase/review/product/list`
    - `POST /reviewPhase/review/export`
    - `GET /reviewPhase/getInfo/{productId}`
- **消息格式**: JSON
- **示例响应**:
```json
{
  "code": 200,
  "msg": "success",
  "data": {
    "total": 5,
    "rows": [
      {
        "projectName": "XX项目",
        "expertCount": 3
      }
    ]
  }
}
```


---

## 模块3：`专家抽取操作与状态管理`

### 功能描述
实现专家抽取操作、抽取确认、取消抽取等核心流程，并支持抽取记录的查询、级联搜索及短信回调处理。

### 输入/输出
- **输入**:
    - 抽取设置对象 [ZjkProjectExpertItemBo](file://D:\jyh-zjk\ruoyi-modules\zjk-api\src\main\java\org\dromara\zjk\domain\bo\ZjkProjectExpertItemBo.java#L16-L69)
    - 查询参数对象 [ZjkItemExtreationBo](file://D:\jyh-zjk\ruoyi-modules\zjk-api\src\main\java\org\dromara\zjk\domain\bo\ZjkItemExtreationBo.java#L17-L66)
- **输出**:
    - 包含抽取结果的 [ZjkExpertItemVo](file://D:\jyh-zjk\ruoyi-modules\zjk-api\src\main\java\org\dromara\zjk\domain\vo\ZjkExpertItemVo.java#L15-L68)
    - 专家级联查询结果 [ZjkExpertVo](file://D:\jyh-zjk\ruoyi-modules\zjk-api\src\main\java\org\dromara\zjk\domain\vo\ZjkExpertVo.java#L16-L75)

### 处理逻辑
```java
// 专家抽取
@PostMapping("/expertltem")
public R<Long> expertltem(@Validated(AddGroup.class) @RequestBody String zjkProjectExpertItemBo) {
    ZjkProjectExpertItemBo itemBo = JSON.parseObject(zjkProjectExpertItemBo, ZjkProjectExpertItemBo.class);
    return R.ok(zjkExpertItemService.expertltem(itemBo));
}

// 取消抽取
@PostMapping("/cancel")
public R<Void> cancel(@Validated(AddGroup.class) @RequestBody ZjkProjectExpertItemBo itemExpertId) {
    zjkExpertItemService.cancel(itemExpertId);
    return R.ok();
}

// 专家级联查询
@GetMapping ("/concatenated")
public R<List<ZjkExpertVo>> concatenated(String name) {
    return R.ok(zjkExpertItemService.concatenated(name));
}
```


### 接口定义
- **API签名**:
    - `POST /project/extract/expertltem`
    - `POST /project/extract/cancel`
    - `GET /project/extract/concatenated`
- **消息格式**: JSON
- **示例响应**:
```json
{
  "code": 200,
  "msg": "success",
  "data": 1
}
```


---

## 模块4：`专家抽取记录管理`

### 功能描述
对抽取记录进行增删改查操作，包括导出抽取列表、获取抽取详情等功能。

### 输入/输出
- **输入**:
    - 抽取记录查询对象 [ZjkItemExtreationBo](file://D:\jyh-zjk\ruoyi-modules\zjk-api\src\main\java\org\dromara\zjk\domain\bo\ZjkItemExtreationBo.java#L17-L66)
    - 分页查询对象 [PageQuery](file://D:\jyh-zjk\ruoyi-common\ruoyi-common-mybatis\src\main\java\org\dromara\common\mybatis\core\page\PageQuery.java#L22-L121)
- **输出**:
    - 包含抽取记录的 [ZjkItemExtreationVo](file://D:\jyh-zjk\ruoyi-modules\zjk-api\src\main\java\org\dromara\zjk\domain\vo\ZjkItemExtreationVo.java#L15-L62)

### 处理逻辑
```java
// 查询专家抽取列表
@GetMapping("/list")
public TableDataInfo<ZjkItemExtreationVo> list(ZjkItemExtreationBo bo, PageQuery pageQuery) {
    bo.setEffective(1); // 筛选有效记录
    return zjkItemExtreationService.queryPageList(bo, pageQuery);
}

// 获取专家抽取详细信息
@GetMapping("/{id}")
public R<ZjkItemExtreationVo> getInfo(@NotNull(message = "主键不能为空")
                                    @PathVariable Long id) {
    return R.ok(zjkItemExtreationService.queryById(id));
}

// 导出专家抽取列表
@PostMapping("/export")
public void export(ZjkItemExtreationBo bo, HttpServletResponse response) {
    List<ZjkItemExtreationVo> list = zjkItemExtreationService.queryList(bo);
    ExcelUtil.exportExcel(list, "抽取", ZjkItemExtreationVo.class, response);
}
```


### 接口定义
- **API签名**:
    - `GET /itemExtreation/list`
    - `GET /itemExtreation/{id}`
    - `POST /itemExtreation/export`
- **消息格式**: JSON
- **示例响应**:
```json
{
  "code": 200,
  "msg": "success",
  "data": {
    "total": 10,
    "rows": [
      {
        "expertName": "张三",
        "projectId": 1001,
        "status": "已抽取"
      }
    ]
  }
}
```


---

## 模块5：`专家合作项目查询`

### 功能描述
根据专家ID获取其参与的评审项目信息，并提供统计分析功能。

### 输入/输出
- **输入**:
    - 评审项目业务对象 [ZjkReviewProductBo](file://D:\jyh-zjk\ruoyi-modules\zjk-api\src\main\java\org\dromara\zjk\domain\bo\ZjkReviewProductBo.java#L16-L69)
    - 分页查询对象 [PageQuery](file://D:\jyh-zjk\ruoyi-common\ruoyi-common-mybatis\src\main\java\org\dromara\common\mybatis\core\page\PageQuery.java#L22-L121)
- **输出**:
    - 包含专家合作项目信息的 [ZjkReviewProductVo](file://D:\jyh-zjk\ruoyi-modules\zjk-api\src\main\java\org\dromara\zjk\domain\vo\ZjkReviewProductVo.java#L14-L62)

### 处理逻辑
```java
// 根据专家ID获取合作项目信息
@GetMapping("/getReviewProductListByExpert")
public TableDataInfo<ZjkReviewProductVo> getReviewProductListByExpert(ZjkReviewProductBo bo, PageQuery pageQuery) {
    return zjkReviewPhaseService.getReviewProductListByExpert(bo, pageQuery);
}

// 获取评审项目数量统计
@GetMapping("/getReview/count")
public R getReviewCount() {
    return R.ok("success", zjkReviewPhaseService.getReviewCount());
}
```


### 接口定义
- **API签名**:
    - `GET /reviewPhase/getReviewProductListByExpert`
    - `GET /reviewPhase/getReview/count`
- **消息格式**: JSON
- **示例响应**:
```json
{
  "code": 200,
  "msg": "success",
  "data": {
    "total": 2,
    "rows": [
      {
        "projectName": "YY项目",
        "startDate": "2024-01-01"
      }
    ]
  }
}
```


