package org.dromara.zjk.domain.bo;

import org.dromara.zjk.domain.ZjkCreditReward;
import org.dromara.common.mybatis.core.domain.BaseEntity;
import org.dromara.common.core.validate.AddGroup;
import org.dromara.common.core.validate.EditGroup;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import lombok.EqualsAndHashCode;
import jakarta.validation.constraints.*;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 信用奖励业务对象 zjk_credit_reward
 *
 * @author ygh
 * @date 2024-11-11
 */
@Data
@EqualsAndHashCode(callSuper = true)
@AutoMapper(target = ZjkCreditReward.class, reverseConvertGenerate = false)
public class ZjkCreditRewardBo extends BaseEntity {

    /**
     * 租户号
     */
    @NotBlank(message = "租户号不能为空", groups = { AddGroup.class, EditGroup.class })
    private String ID;

    /**
     * 信用奖励名称
     */
    @NotBlank(message = "信用奖励名称不能为空", groups = { AddGroup.class, EditGroup.class })
    private String rewardName;

    /**
     * 激励类型;字典值credit_reward_type
     */
    @NotNull(message = "激励类型;字典值credit_reward_type不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long rewardType;

    /**
     * 激励内容
     */
    @NotBlank(message = "激励内容不能为空", groups = { AddGroup.class, EditGroup.class })
    private String rewardContent;

    /**
     * 激励标的;字典值 信用
     */
    @NotNull(message = "激励标的;字典值 信用不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long rewardObj;

    /**
     * 生效符号;><=
     */
    @NotNull(message = "生效符号;><=不能为空", groups = { AddGroup.class, EditGroup.class })
    private String effectFlag;

    /**
     * 生效标准;临界分值
     */
    @NotNull(message = "生效标准;临界分值不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long effectStandard;

    /**
     * 激励截至时间
     */
    @NotNull(message = "激励截至时间不能为空", groups = { AddGroup.class, EditGroup.class })
    private Date rewardUntil;

    /**
     * 是否永久;1：永久；0不永久
     */
    @NotNull(message = "是否永久;1：永久；0不永久不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long isForever;

    /**
     * 启用标识
     */
    @NotNull(message = "启用标识不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long status;


}
