package org.dromara.zjk.domain.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serial;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author : yanguohua
 * @version : 1.0
 * @date : 2024/11/26 15:01
 */
@Data
@NoArgsConstructor
public class StsListVO implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;
    @ExcelProperty(value = "专家名称")
    private String expertName;
    @ExcelProperty(value = "工作单位")
    private String workUnit;
    @ExcelProperty(value = "职务")
    private String duty;
    @ExcelProperty(value = "专家入库时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date approvalTime;
    @ExcelProperty(value = "参与评审项目数")
    private Long joinProNums;
    @ExcelProperty(value = "最近一次评审时间")
    private Date closeTime;
    @ExcelProperty(value = "星级总分")
    private Long scoreSum;
    @ExcelProperty(value = "星级均分")
    private BigDecimal scoreAvg;
    @ExcelProperty(value = "评价等级")
    private String evaRank;

}
