package org.dromara.zjk.domain.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.dromara.zjk.domain.ZjkProductReviewsn;
import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import org.dromara.common.excel.annotation.ExcelDictFormat;
import org.dromara.common.excel.convert.ExcelDictConvert;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serial;
import java.io.Serializable;
import java.util.Date;



/**
 * 项目阶段文档管理视图对象 zjk_product_reviewsn
 *
 * @author wt
 * @date 2024-11-22
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = ZjkProductReviewsn.class)
public class ZjkProductReviewsnVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @ExcelProperty(value = "id")
    private Long id;

    /**
     * 项目id
     */
    @ExcelProperty(value = "项目id")
    private Long productId;

    /**
     * 项目阶段
     */
    @ExcelProperty(value = "项目阶段")
    private String reviewSn;

    /**
     * 状态
     */
    @ExcelProperty(value = "状态")
    private String status;

    /**
     * 备注
     */
    @ExcelProperty(value = "备注")
    private String remark;


    @ExcelProperty(value = "原始文件名称")
    private String originalName;

    private String url;


    private Integer type;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    private String productName;
}
