package org.dromara.zjk.learning_world.domain.bo;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.dromara.common.core.utils.DateUtils;
import org.dromara.zjk.learning_world.domain.entity.ZjkLearningInformation;
import org.dromara.common.mybatis.core.domain.BaseEntity;
import org.dromara.common.core.validate.AddGroup;
import org.dromara.common.core.validate.EditGroup;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import lombok.EqualsAndHashCode;
import jakarta.validation.constraints.*;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 资讯业务对象 zjk_learning_information
 *
 * @author ygh
 * @date 2024-11-11
 */
@Data
@EqualsAndHashCode(callSuper = true)
@AutoMapper(target = ZjkLearningInformation.class, reverseConvertGenerate = false)
public class ZjkLearningInformationBo extends BaseEntity {

    /**
     * id
     */
    @NotNull(message = "id不能为空", groups = {EditGroup.class })
    private Long id;

    /**
     * 资讯类型
     */
    @NotBlank(message = "资讯类型不能为空", groups = { AddGroup.class })
    private String informationClassifyId;

    /**
     * 资讯封面
     */
    @NotBlank(message = "资讯封面不能为空", groups = { AddGroup.class })
    private String informationImage;

    /**
     * 资讯标题
     */
    @NotBlank(message = "资讯标题不能为空", groups = { AddGroup.class })
    private String informationTitle;

    /**
     * 资讯详情
     */
    @NotBlank(message = "资讯详情不能为空", groups = { AddGroup.class})
    private String informationDetail;

    /**
     * 状态
     */
    @NotBlank(message = "状态不能为空", groups = { AddGroup.class })
    private String status;

    /**
     * 备注
     */
    private String remark;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 撤销时间
     */
    private Date takedownTime;

    /**
     * 评论数量
     */
    private Integer commentCount;

    @JsonFormat(pattern = DateUtils.YYYY_MM_DD_HH_MM_SS,timezone="GMT+8")
    @DateTimeFormat(pattern = DateUtils.YYYY_MM_DD_HH_MM_SS)
    private Date startTime;
    @JsonFormat(pattern = DateUtils.YYYY_MM_DD_HH_MM_SS,timezone="GMT+8")
    @DateTimeFormat(pattern = DateUtils.YYYY_MM_DD_HH_MM_SS)
    private Date endTime;
}
