package org.dromara.zjk.learning_world.domain.entity;

import org.dromara.common.tenant.core.TenantEntity;
import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.dromara.zjk.annotation.PropertyMsg;
import java.io.Serial;
import java.util.Date;

/**
 * 资讯对象 zjk_learning_information
 *
 * @author ygh
 * @date 2024-11-11
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("zjk_learning_information")
public class ZjkLearningInformation extends TenantEntity {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @PropertyMsg(propertyName = "id")
    private Long id;

    /**
     * 资讯类型
     */
    @PropertyMsg(propertyName = "informationClassifyId")
    private String informationClassifyId;

    /**
     * 资讯封面
     */
    @PropertyMsg(propertyName = "informationImage")
    private String informationImage;

    /**
     * 资讯标题
     */
    @PropertyMsg(propertyName = "informationTitle")
    private String informationTitle;

    /**
     * 资讯详情
     */
    @PropertyMsg(propertyName = "informationDetail")
    private String informationDetail;

    /**
     * 状态
     */
    @PropertyMsg(propertyName = "status")
    private String status;

    /**
     * 备注
     */
    @PropertyMsg(propertyName = "remark")
    private String remark;

    /**
     * 是否删除
     */
    @TableLogic
    @PropertyMsg(propertyName = "del_flag")
    private Long delFlag;

    /**
     * 用户id
     */
    @PropertyMsg(propertyName = "user_id")
    private Long userId;
    /**
     * 上下架时间
     */
    @PropertyMsg(propertyName = "撤销时间")
    private Date takedownTime;

    @PropertyMsg(propertyName = "评论数量")
    private Integer commentCount;

}
