package org.dromara.zjk.learning_world.domain.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import org.dromara.zjk.learning_world.domain.entity.ZjkLearningCommont;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serial;
import java.io.Serializable;
import java.util.Date;
import java.util.List;


/**
 * 评论视图对象 zjk_learning_commont
 *
 * @author ygh
 * @date 2024-11-11
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = ZjkLearningCommont.class)
public class ZjkLearningCommontVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @ExcelProperty(value = "id")
    private Long id;

    /**
     * 资讯id
     */
    @ExcelProperty(value = "资讯id")
    private Long informationId;

    @ExcelProperty(value = "资讯Title")
    private String informationTitle;

    /**
     * 评论人
     */
    @ExcelProperty(value = "评论人")
    private Long reviewerId;

    /**
     * 被回复人ID
     */
    @ExcelProperty(value = "被回复人ID")
    private Long replyId;

    /**
     * 评论
     */
    @ExcelProperty(value = "评论")
    private String comment;

    /**
     * 评论时间
     */
    @ExcelProperty(value = "评论时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date commentTime;

    /**
     * 状态
     */
    @ExcelProperty(value = "状态")
    private String status;

    /**
     * 备注
     */
    @ExcelProperty(value = "备注")
    private String remark;

    /**
     * 撤销时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ExcelProperty(value = "撤销时间")
    private Date takedownTime;

    @ExcelProperty(value = "上级")
    private Long  parentId;

    @ExcelProperty(value = "专家名称")
    private String  expertName;

    @ExcelProperty(value = "专家头像")
    private String  expertPhotograph;

    @ExcelProperty(value = "部门名称")
    private String  deptName;

    @ExcelProperty(value = "被回复人名称")
    private String replyName;

    @ExcelProperty(value = "被回复人头像")
    private String replyPhotograph;
    @ExcelProperty(value = "部门名称")
    private String  replyDeptName;

    /**
     * 是否显示删除按钮
     */
    private boolean isDeleted;

    /**
     * 是否显示回复按钮
     */
    private boolean isReply;
    /**
     * 回复
     */
    private List<ZjkLearningCommontVo> commontVoList;
}
