/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.control.remote;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.remote.request.Request;
import com.alibaba.nacos.api.remote.request.RequestMeta;
import com.alibaba.nacos.api.remote.response.Response;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.control.TpsControl;
import com.alibaba.nacos.core.control.TpsControlConfig;
import com.alibaba.nacos.core.control.remote.RemoteTpsCheckRequestParser;
import com.alibaba.nacos.core.control.remote.RemoteTpsCheckRequestParserRegistry;
import com.alibaba.nacos.core.remote.AbstractRequestFilter;
import com.alibaba.nacos.plugin.control.ControlManagerCenter;
import com.alibaba.nacos.plugin.control.Loggers;
import com.alibaba.nacos.plugin.control.tps.TpsControlManager;
import com.alibaba.nacos.plugin.control.tps.request.TpsCheckRequest;
import com.alibaba.nacos.plugin.control.tps.response.TpsCheckResponse;
import java.lang.reflect.Method;
import org.springframework.stereotype.Service;

@Service
public class TpsControlRequestFilter
extends AbstractRequestFilter {
    private TpsControlManager tpsControlManager;

    @Override
    protected Response filter(Request request, RequestMeta meta, Class handlerClazz) {
        Method method;
        try {
            method = this.getHandleMethod(handlerClazz);
        }
        catch (NacosException e) {
            return null;
        }
        if (method.isAnnotationPresent(TpsControl.class) && TpsControlConfig.isTpsControlEnabled()) {
            try {
                TpsControl tpsControl = method.getAnnotation(TpsControl.class);
                String pointName = tpsControl.pointName();
                TpsCheckRequest tpsCheckRequest = null;
                String parseName = StringUtils.isBlank((CharSequence)tpsControl.name()) ? pointName : tpsControl.name();
                RemoteTpsCheckRequestParser parser = RemoteTpsCheckRequestParserRegistry.getParser(parseName);
                if (parser != null) {
                    tpsCheckRequest = parser.parse(request, meta);
                }
                if (tpsCheckRequest == null) {
                    tpsCheckRequest = new TpsCheckRequest();
                }
                if (StringUtils.isBlank((CharSequence)tpsCheckRequest.getPointName())) {
                    tpsCheckRequest.setPointName(pointName);
                }
                this.initTpsControlManager();
                TpsCheckResponse check = this.tpsControlManager.check(tpsCheckRequest);
                if (!check.isSuccess()) {
                    try {
                        Response response = super.getDefaultResponseInstance(handlerClazz);
                        response.setErrorInfo(503, "Tps Flow restricted:" + check.getMessage());
                        return response;
                    }
                    catch (Exception e) {
                        Loggers.TPS.warn("Tps check fail , request: {},exception:{}", (Object)request.getClass().getSimpleName(), (Object)e);
                        return null;
                    }
                }
            }
            catch (Throwable throwable) {
                Loggers.TPS.warn("Tps check exception , request: {},exception:{}", (Object)request.getClass().getSimpleName(), (Object)throwable);
            }
        }
        return null;
    }

    private void initTpsControlManager() {
        if (this.tpsControlManager == null) {
            this.tpsControlManager = ControlManagerCenter.getInstance().getTpsControlManager();
        }
    }
}

