/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.remote;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.remote.request.Request;
import com.alibaba.nacos.api.remote.request.RequestMeta;
import com.alibaba.nacos.api.remote.response.Response;
import com.alibaba.nacos.core.remote.RequestFilters;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractRequestFilter {
    @Autowired
    private RequestFilters requestFilters;

    @PostConstruct
    public void init() {
        this.requestFilters.registerFilter(this);
    }

    protected Method getHandleMethod(Class handlerClazz) throws NacosException {
        try {
            Method method = handlerClazz.getMethod("handle", Request.class, RequestMeta.class);
            return method;
        }
        catch (NoSuchMethodException e) {
            throw new NacosException(500, (Throwable)e);
        }
    }

    protected <T> Response getDefaultResponseInstance(Class handlerClazz) throws NacosException {
        ParameterizedType parameterizedType = (ParameterizedType)handlerClazz.getGenericSuperclass();
        try {
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            return (Response)Class.forName(actualTypeArguments[1].getTypeName()).newInstance();
        }
        catch (Exception e) {
            throw new NacosException(500, (Throwable)e);
        }
    }

    protected abstract Response filter(Request var1, RequestMeta var2, Class var3) throws NacosException;
}

