/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.web.util.compat;

import com.tongweb.web.util.compat.Jre16Compat;
import com.tongweb.web.util.compat.Jre19Compat;
import com.tongweb.web.util.res.StringManager;
import java.lang.reflect.Field;
import java.net.SocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;

public class JreCompat {
    private static final JreCompat instance;
    private static final boolean graalAvailable;
    private static final boolean jre16Available;
    private static final boolean jre19Available;
    private static final StringManager sm;

    public static JreCompat getInstance() {
        return instance;
    }

    public static boolean isGraalAvailable() {
        return graalAvailable;
    }

    public static boolean isJre16Available() {
        return jre16Available;
    }

    public static boolean isJre19Available() {
        return jre19Available;
    }

    public SocketAddress getUnixDomainSocketAddress(String path) {
        return null;
    }

    public ServerSocketChannel openUnixDomainServerSocketChannel() {
        throw new UnsupportedOperationException(sm.getString("jreCompat.noUnixDomainSocket"));
    }

    public SocketChannel openUnixDomainSocketChannel() {
        throw new UnsupportedOperationException(sm.getString("jreCompat.noUnixDomainSocket"));
    }

    public Object getExecutor(Thread thread) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Object result = null;
        Object target = null;
        for (String fieldName : new String[]{"target", "runnable", "action"}) {
            try {
                Field targetField = thread.getClass().getDeclaredField(fieldName);
                targetField.setAccessible(true);
                target = targetField.get(thread);
                break;
            }
            catch (NoSuchFieldException nfe) {
            }
        }
        if (target != null && target.getClass().getCanonicalName() != null && (target.getClass().getCanonicalName().equals("com.tongweb.web.util.threads.ThreadPoolExecutor.Worker") || target.getClass().getCanonicalName().equals("java.util.concurrent.ThreadPoolExecutor.Worker"))) {
            Field executorField = target.getClass().getDeclaredField("this$0");
            executorField.setAccessible(true);
            result = executorField.get(target);
        }
        return result;
    }

    static {
        sm = StringManager.getManager(JreCompat.class);
        boolean result = false;
        try {
            Class<?> nativeImageClazz = Class.forName("org.graalvm.nativeimage.ImageInfo");
            result = Boolean.TRUE.equals(nativeImageClazz.getMethod("inImageCode", new Class[0]).invoke(null, new Object[0]));
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalArgumentException | ReflectiveOperationException exception) {
            // empty catch block
        }
        boolean bl = graalAvailable = result || System.getProperty("org.graalvm.nativeimage.imagecode") != null;
        if (Jre19Compat.isSupported()) {
            instance = new Jre19Compat();
            jre19Available = true;
            jre16Available = true;
        } else if (Jre16Compat.isSupported()) {
            instance = new Jre16Compat();
            jre19Available = false;
            jre16Available = true;
        } else {
            instance = new JreCompat();
            jre19Available = false;
            jre16Available = false;
        }
    }
}

