/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.springboot.actuate.instrument.binder.tongweb;

import com.tongweb.container.Manager;
import io.micrometer.common.lang.NonNullApi;
import io.micrometer.common.lang.NonNullFields;
import io.micrometer.common.lang.Nullable;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.TimeGauge;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerFactory;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

@NonNullApi
@NonNullFields
public class TongWebMetrics
implements MeterBinder,
AutoCloseable {
    private static final String JMX_DOMAIN_EMBEDDED = "TongWeb";
    private static final String JMX_DOMAIN_STANDALONE = "TongWeb";
    private static final String OBJECT_NAME_SERVER_SUFFIX = ":type=Server";
    private static final String OBJECT_NAME_SERVER_EMBEDDED = "TongWeb:type=Server";
    private static final String OBJECT_NAME_SERVER_STANDALONE = "TongWeb:type=Server";
    @Nullable
    private final Manager manager;
    private final MBeanServer mBeanServer;
    private final Iterable<Tag> tags;
    private final Set<NotificationListener> notificationListeners = ConcurrentHashMap.newKeySet();
    private volatile String jmxDomain;

    public TongWebMetrics(@Nullable Manager manager, Iterable<Tag> tags) {
        this(manager, tags, TongWebMetrics.getMBeanServer());
    }

    public TongWebMetrics(@Nullable Manager manager, Iterable<Tag> tags, MBeanServer mBeanServer) {
        this.manager = manager;
        this.tags = tags;
        this.mBeanServer = mBeanServer;
        if (manager != null) {
            this.jmxDomain = manager.getContext().getDomain();
        }
    }

    public static void monitor(MeterRegistry registry, @Nullable Manager manager, String ... tags) {
        TongWebMetrics.monitor(registry, manager, (Iterable<Tag>)Tags.of((String[])tags));
    }

    public static void monitor(MeterRegistry registry, @Nullable Manager manager, Iterable<Tag> tags) {
        new TongWebMetrics(manager, tags).bindTo(registry);
    }

    public static MBeanServer getMBeanServer() {
        ArrayList<MBeanServer> mBeanServers = MBeanServerFactory.findMBeanServer(null);
        if (!mBeanServers.isEmpty()) {
            return (MBeanServer)mBeanServers.get(0);
        }
        return ManagementFactory.getPlatformMBeanServer();
    }

    public void bindTo(MeterRegistry registry) {
        this.registerGlobalRequestMetrics(registry);
        this.registerServletMetrics(registry);
        this.registerCacheMetrics(registry);
        this.registerThreadPoolMetrics(registry);
        this.registerSessionMetrics(registry);
    }

    private void registerSessionMetrics(MeterRegistry registry) {
        if (this.manager != null) {
            Gauge.builder((String)"tongweb.sessions.active.max", (Object)this.manager, Manager::getMaxActive).tags(this.tags).baseUnit("sessions").register(registry);
            Gauge.builder((String)"tongweb.sessions.active.current", (Object)this.manager, Manager::getActiveSessions).tags(this.tags).baseUnit("sessions").register(registry);
            FunctionCounter.builder((String)"tongweb.sessions.created", (Object)this.manager, Manager::getSessionCounter).tags(this.tags).baseUnit("sessions").register(registry);
            FunctionCounter.builder((String)"tongweb.sessions.expired", (Object)this.manager, Manager::getExpiredSessions).tags(this.tags).baseUnit("sessions").register(registry);
            FunctionCounter.builder((String)"tongweb.sessions.rejected", (Object)this.manager, Manager::getRejectedSessions).tags(this.tags).baseUnit("sessions").register(registry);
            TimeGauge.builder((String)"tongweb.sessions.alive.max", (Object)this.manager, (TimeUnit)TimeUnit.SECONDS, Manager::getSessionMaxAliveTime).tags(this.tags).register(registry);
        }
    }

    private void registerThreadPoolMetrics(MeterRegistry registry) {
        this.registerMetricsEventually(":type=ThreadPool,name=*", (name, allTags) -> {
            Gauge.builder((String)"tongweb.threads.config.max", (Object)this.mBeanServer, s -> this.safeDouble(() -> s.getAttribute((ObjectName)name, "maxThreads"))).tags(allTags).baseUnit("threads").register(registry);
            Gauge.builder((String)"tongweb.threads.busy", (Object)this.mBeanServer, s -> this.safeDouble(() -> s.getAttribute((ObjectName)name, "currentThreadsBusy"))).tags(allTags).baseUnit("threads").register(registry);
            Gauge.builder((String)"tongweb.threads.current", (Object)this.mBeanServer, s -> this.safeDouble(() -> s.getAttribute((ObjectName)name, "currentThreadCount"))).tags(allTags).baseUnit("threads").register(registry);
            Gauge.builder((String)"tongweb.connections.current", (Object)this.mBeanServer, s -> this.safeDouble(() -> s.getAttribute((ObjectName)name, "connectionCount"))).tags(allTags).baseUnit("connections").register(registry);
            Gauge.builder((String)"tongweb.connections.keepalive.current", (Object)this.mBeanServer, s -> this.safeDouble(() -> s.getAttribute((ObjectName)name, "keepAliveCount"))).tags(allTags).baseUnit("connections").register(registry);
            Gauge.builder((String)"tongweb.connections.config.max", (Object)this.mBeanServer, s -> this.safeDouble(() -> s.getAttribute((ObjectName)name, "maxConnections"))).tags(allTags).baseUnit("connections").register(registry);
        });
    }

    private void registerCacheMetrics(MeterRegistry registry) {
        this.registerMetricsEventually(":type=StringCache", (name, allTags) -> {
            FunctionCounter.builder((String)"tongweb.cache.access", (Object)this.mBeanServer, s -> this.safeDouble(() -> s.getAttribute((ObjectName)name, "accessCount"))).tags(allTags).register(registry);
            FunctionCounter.builder((String)"tongweb.cache.hit", (Object)this.mBeanServer, s -> this.safeDouble(() -> s.getAttribute((ObjectName)name, "hitCount"))).tags(allTags).register(registry);
        });
    }

    private void registerServletMetrics(MeterRegistry registry) {
        this.registerMetricsEventually(":j2eeType=Servlet,name=*,*", (name, allTags) -> {
            FunctionCounter.builder((String)"tongweb.servlet.error", (Object)this.mBeanServer, s -> this.safeDouble(() -> s.getAttribute((ObjectName)name, "errorCount"))).tags(allTags).register(registry);
            FunctionTimer.builder((String)"tongweb.servlet.request", (Object)this.mBeanServer, s -> this.safeLong(() -> s.getAttribute((ObjectName)name, "requestCount")), s -> this.safeDouble(() -> s.getAttribute((ObjectName)name, "processingTime")), (TimeUnit)TimeUnit.MILLISECONDS).tags(allTags).register(registry);
            TimeGauge.builder((String)"tongweb.servlet.request.max", (Object)this.mBeanServer, (TimeUnit)TimeUnit.MILLISECONDS, s -> this.safeDouble(() -> s.getAttribute((ObjectName)name, "maxTime"))).tags(allTags).register(registry);
        });
    }

    private void registerGlobalRequestMetrics(MeterRegistry registry) {
        this.registerMetricsEventually(":type=GlobalRequestProcessor,name=*", (name, allTags) -> {
            FunctionCounter.builder((String)"tongweb.global.sent", (Object)this.mBeanServer, s -> this.safeDouble(() -> s.getAttribute((ObjectName)name, "bytesSent"))).tags(allTags).baseUnit("bytes").register(registry);
            FunctionCounter.builder((String)"tongweb.global.received", (Object)this.mBeanServer, s -> this.safeDouble(() -> s.getAttribute((ObjectName)name, "bytesReceived"))).tags(allTags).baseUnit("bytes").register(registry);
            FunctionCounter.builder((String)"tongweb.global.error", (Object)this.mBeanServer, s -> this.safeDouble(() -> s.getAttribute((ObjectName)name, "errorCount"))).tags(allTags).register(registry);
            FunctionTimer.builder((String)"tongweb.global.request", (Object)this.mBeanServer, s -> this.safeLong(() -> s.getAttribute((ObjectName)name, "requestCount")), s -> this.safeDouble(() -> s.getAttribute((ObjectName)name, "processingTime")), (TimeUnit)TimeUnit.MILLISECONDS).tags(allTags).register(registry);
            TimeGauge.builder((String)"tongweb.global.request.max", (Object)this.mBeanServer, (TimeUnit)TimeUnit.MILLISECONDS, s -> this.safeDouble(() -> s.getAttribute((ObjectName)name, "maxTime"))).tags(allTags).register(registry);
        });
    }

    private void registerMetricsEventually(final String namePatternSuffix, final BiConsumer<ObjectName, Iterable<Tag>> perObject) {
        Set<ObjectName> objectNames;
        if (this.getJmxDomain() != null && !(objectNames = this.mBeanServer.queryNames(this.getNamePattern(namePatternSuffix), null)).isEmpty()) {
            objectNames.forEach(objectName -> perObject.accept((ObjectName)objectName, (Iterable<Tag>)Tags.concat(this.tags, this.nameTag((ObjectName)objectName))));
            return;
        }
        NotificationListener notificationListener = new NotificationListener(){

            @Override
            public void handleNotification(Notification notification, Object handback) {
                MBeanServerNotification mBeanServerNotification = (MBeanServerNotification)notification;
                ObjectName objectName = mBeanServerNotification.getMBeanName();
                perObject.accept(objectName, Tags.concat(TongWebMetrics.this.tags, TongWebMetrics.this.nameTag(objectName)));
                if (!TongWebMetrics.this.getNamePattern(namePatternSuffix).isPattern()) {
                    try {
                        TongWebMetrics.this.mBeanServer.removeNotificationListener(MBeanServerDelegate.DELEGATE_NAME, this);
                        TongWebMetrics.this.notificationListeners.remove(this);
                    }
                    catch (InstanceNotFoundException | ListenerNotFoundException var6) {
                        throw new RuntimeException(var6);
                    }
                }
            }
        };
        this.notificationListeners.add(notificationListener);
        NotificationFilter notificationFilter = notification -> {
            if (!"JMX.mbean.registered".equals(notification.getType())) {
                return false;
            }
            ObjectName objectName = ((MBeanServerNotification)notification).getMBeanName();
            return this.getNamePattern(namePatternSuffix).apply(objectName);
        };
        try {
            this.mBeanServer.addNotificationListener(MBeanServerDelegate.DELEGATE_NAME, notificationListener, notificationFilter, null);
        }
        catch (InstanceNotFoundException var6) {
            throw new RuntimeException("Error registering MBean listener", var6);
        }
    }

    private ObjectName getNamePattern(String namePatternSuffix) {
        try {
            return new ObjectName(this.getJmxDomain() + namePatternSuffix);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Error registering TongWeb JMX based metrics", e);
        }
    }

    private String getJmxDomain() {
        if (this.jmxDomain == null) {
            if (this.hasObjectName("TongWeb:type=Server")) {
                this.jmxDomain = "TongWeb";
            } else if (this.hasObjectName("TongWeb:type=Server")) {
                this.jmxDomain = "TongWeb";
            }
        }
        return this.jmxDomain;
    }

    public void setJmxDomain(String jmxDomain) {
        this.jmxDomain = jmxDomain;
    }

    private boolean hasObjectName(String name) {
        try {
            return this.mBeanServer.queryNames(new ObjectName(name), null).size() == 1;
        }
        catch (MalformedObjectNameException ex) {
            throw new RuntimeException(ex);
        }
    }

    private double safeDouble(Callable<Object> callable) {
        try {
            return Double.parseDouble(callable.call().toString());
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    private long safeLong(Callable<Object> callable) {
        try {
            return Long.parseLong(callable.call().toString());
        }
        catch (Exception e) {
            return 0L;
        }
    }

    private Iterable<Tag> nameTag(ObjectName name) {
        String nameTagValue = name.getKeyProperty("name");
        if (nameTagValue != null) {
            return Tags.of((String)"name", (String)nameTagValue.replaceAll("\"", ""));
        }
        return Collections.emptyList();
    }

    @Override
    public void close() {
        for (NotificationListener notificationListener : this.notificationListeners) {
            try {
                this.mBeanServer.removeNotificationListener(MBeanServerDelegate.DELEGATE_NAME, notificationListener);
            }
            catch (InstanceNotFoundException | ListenerNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

