/*
 * Decompiled with CFR 0.152.
 */
package cn.bubi;

import cn.bubi.account.AccountService;
import cn.bubi.account.impl.AccountServiceImpl;
import cn.bubi.blockchain.BlockService;
import cn.bubi.blockchain.TransactionService;
import cn.bubi.blockchain.impl.BlockServiceImpl;
import cn.bubi.blockchain.impl.TransactionServiceImpl;
import cn.bubi.common.Tools;
import cn.bubi.contract.ContractService;
import cn.bubi.contract.impl.ContractServiceImpl;
import cn.bubi.crypto.http.HttpKit;
import cn.bubi.exception.SDKException;
import cn.bubi.exception.SdkError;
import cn.bubi.model.request.SDKConfigure;
import cn.bubi.token.AssetService;
import cn.bubi.token.impl.AssetServiceImpl;

public class SDK {
    private static SDK sdk = null;
    private String url;
    private long chainId = 0L;

    private SDK() {
    }

    public static synchronized SDK getInstance(String url) throws SDKException {
        if (sdk == null) {
            sdk = new SDK();
        }
        sdk.init(url);
        return sdk;
    }

    public static synchronized SDK getInstance(SDKConfigure sdkConfigure) throws SDKException {
        if (sdk == null) {
            sdk = new SDK();
        }
        sdk.init(sdkConfigure);
        return sdk;
    }

    public AccountService getAccountService() {
        return new AccountServiceImpl();
    }

    public AssetService getAssetService() {
        return new AssetServiceImpl();
    }

    public TransactionService getTransactionService() {
        return new TransactionServiceImpl();
    }

    public BlockService getBlockService() {
        return new BlockServiceImpl();
    }

    public ContractService getContractService() {
        return new ContractServiceImpl();
    }

    public static SDK getSdk() {
        return sdk;
    }

    public String getUrl() {
        return this.url;
    }

    public long getChainId() {
        return this.chainId;
    }

    private void init(SDKConfigure sdkConfigure) throws SDKException {
        long chainId;
        int readTimeOut;
        if (Tools.isEmpty(sdkConfigure.getUrl()).booleanValue()) {
            throw new SDKException(SdkError.URL_EMPTY_ERROR);
        }
        SDK.sdk.url = sdkConfigure.getUrl();
        int httpConnectTimeOut = sdkConfigure.getHttpConnectTimeOut();
        if (httpConnectTimeOut > 0) {
            HttpKit.connectTimeOut = httpConnectTimeOut;
        }
        if ((readTimeOut = sdkConfigure.getHttpReadTimeOut()) > 0) {
            HttpKit.readTimeOut = readTimeOut;
        }
        if ((chainId = sdkConfigure.getChainId()) > 0L) {
            SDK.sdk.chainId = chainId;
        }
    }

    private void init(String url) throws SDKException {
        if (Tools.isEmpty(url).booleanValue()) {
            throw new SDKException(SdkError.URL_EMPTY_ERROR);
        }
        SDK.sdk.url = url;
    }
}

