/*
 * Decompiled with CFR 0.152.
 */
package cn.bubi.account.impl;

import cn.bubi.account.AccountService;
import cn.bubi.common.Constant;
import cn.bubi.common.General;
import cn.bubi.common.Tools;
import cn.bubi.crypto.http.HttpKit;
import cn.bubi.crypto.protobuf.Chain;
import cn.bubi.encryption.exception.EncException;
import cn.bubi.encryption.key.PrivateKey;
import cn.bubi.encryption.key.PublicKey;
import cn.bubi.exception.SDKException;
import cn.bubi.exception.SdkError;
import cn.bubi.model.request.AccountCheckActivatedRequst;
import cn.bubi.model.request.AccountCheckValidRequest;
import cn.bubi.model.request.AccountGetAssetsRequest;
import cn.bubi.model.request.AccountGetBalanceRequest;
import cn.bubi.model.request.AccountGetInfoRequest;
import cn.bubi.model.request.AccountGetMetadataRequest;
import cn.bubi.model.request.AccountGetNonceRequest;
import cn.bubi.model.request.operation.AccountActivateOperation;
import cn.bubi.model.request.operation.AccountSetMetadataOperation;
import cn.bubi.model.request.operation.AccountSetPrivilegeOperation;
import cn.bubi.model.response.AccountCheckActivatedResponse;
import cn.bubi.model.response.AccountCheckValidResponse;
import cn.bubi.model.response.AccountCreateResponse;
import cn.bubi.model.response.AccountGetAssetsResponse;
import cn.bubi.model.response.AccountGetBalanceResponse;
import cn.bubi.model.response.AccountGetInfoResponse;
import cn.bubi.model.response.AccountGetMetadataResponse;
import cn.bubi.model.response.AccountGetNonceResponse;
import cn.bubi.model.response.result.AccountCheckActivatedResult;
import cn.bubi.model.response.result.AccountCheckValidResult;
import cn.bubi.model.response.result.AccountCreateResult;
import cn.bubi.model.response.result.AccountGetAssetsResult;
import cn.bubi.model.response.result.AccountGetBalanceResult;
import cn.bubi.model.response.result.AccountGetInfoResult;
import cn.bubi.model.response.result.AccountGetMetadataResult;
import cn.bubi.model.response.result.AccountGetNonceResult;
import cn.bubi.model.response.result.data.Signer;
import cn.bubi.model.response.result.data.TypeThreshold;
import com.alibaba.fastjson.JSON;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.regex.Pattern;

public class AccountServiceImpl
implements AccountService {
    public static Chain.Operation activate(AccountActivateOperation accountActivateOperation, String transSourceAddress) throws SDKException {
        Chain.Operation operation;
        try {
            boolean isNotValid;
            if (Tools.isEmpty(accountActivateOperation).booleanValue()) {
                throw new SDKException(SdkError.REQUEST_NULL_ERROR);
            }
            String sourceAddress = accountActivateOperation.getSourceAddress();
            if (!Tools.isEmpty(sourceAddress).booleanValue() && !PublicKey.isAddressValid((String)sourceAddress)) {
                throw new SDKException(SdkError.INVALID_SOURCEADDRESS_ERROR);
            }
            String destAddress = accountActivateOperation.getDestAddress();
            if (!PublicKey.isAddressValid((String)destAddress)) {
                throw new SDKException(SdkError.INVALID_DESTADDRESS_ERROR);
            }
            boolean bl = isNotValid = Tools.isEmpty(sourceAddress) == false && sourceAddress.equals(destAddress) || transSourceAddress.equals(destAddress);
            if (isNotValid) {
                throw new SDKException(SdkError.SOURCEADDRESS_EQUAL_DESTADDRESS_ERROR);
            }
            Long initBalance = accountActivateOperation.getInitBalance();
            if (Tools.isEmpty(initBalance).booleanValue() || initBalance <= 0L) {
                throw new SDKException(SdkError.INVALID_INITBALANCE_ERROR);
            }
            String metadata = accountActivateOperation.getMetadata();
            operation = AccountServiceImpl.buildActivateOperation(sourceAddress, destAddress, initBalance, metadata);
        }
        catch (SDKException sdkException) {
            throw sdkException;
        }
        catch (Exception e) {
            throw new SDKException(SdkError.SYSTEM_ERROR.getCode(), e.getMessage());
        }
        return operation;
    }

    public static Chain.Operation setMetadata(AccountSetMetadataOperation accountSetMetadataOperation) throws SDKException {
        Chain.Operation.Builder operation;
        try {
            String sourceAddress = accountSetMetadataOperation.getSourceAddress();
            if (!Tools.isEmpty(sourceAddress).booleanValue() && !PublicKey.isAddressValid((String)sourceAddress)) {
                throw new SDKException(SdkError.INVALID_SOURCEADDRESS_ERROR);
            }
            String key = accountSetMetadataOperation.getKey();
            if (Tools.isEmpty(key).booleanValue() || (long)key.length() > Constant.METADATA_KEY_MAX) {
                throw new SDKException(SdkError.INVALID_DATAKEY_ERROR);
            }
            String value = accountSetMetadataOperation.getValue();
            if (Tools.isEmpty(value).booleanValue() || (long)value.length() > Constant.METADATA_VALUE_MAX) {
                throw new SDKException(SdkError.INVALID_DATAVALUE_ERROR);
            }
            Long version = accountSetMetadataOperation.getVersion();
            if (!Tools.isNULL(version).booleanValue() && version < 0L) {
                throw new SDKException(SdkError.INVALID_DATAVERSION_ERROR);
            }
            Boolean deleteFlag = accountSetMetadataOperation.getDeleteFlag();
            String metadata = accountSetMetadataOperation.getMetadata();
            operation = Chain.Operation.newBuilder();
            operation.setType(Chain.Operation.Type.SET_METADATA);
            if (!Tools.isEmpty(sourceAddress).booleanValue()) {
                operation.setSourceAddress(sourceAddress);
            }
            if (!Tools.isEmpty(metadata).booleanValue()) {
                operation.setMetadata(ByteString.copyFromUtf8((String)metadata));
            }
            Chain.OperationSetMetadata.Builder operationSetMetadata = operation.getSetMetadataBuilder();
            operationSetMetadata.setKey(key);
            operationSetMetadata.setValue(value);
            if (!Tools.isEmpty(version).booleanValue() && version > 0L) {
                operationSetMetadata.setVersion(version);
            }
            if (!Tools.isEmpty(deleteFlag).booleanValue() && deleteFlag.booleanValue()) {
                operationSetMetadata.setDeleteFlag(deleteFlag);
            }
        }
        catch (SDKException sdkException) {
            throw sdkException;
        }
        catch (Exception e) {
            throw new SDKException(SdkError.SYSTEM_ERROR.getCode(), e.getMessage());
        }
        return operation.build();
    }

    public static Chain.Operation setPrivilege(AccountSetPrivilegeOperation accountSetPrivilegeOperation) throws SDKException {
        Chain.Operation operation;
        try {
            Pattern pattern;
            boolean isNumber;
            Pattern pattern2;
            boolean isNumber2;
            String sourceAddress = accountSetPrivilegeOperation.getSourceAddress();
            if (!Tools.isEmpty(sourceAddress).booleanValue() && !PublicKey.isAddressValid((String)sourceAddress)) {
                throw new SDKException(SdkError.INVALID_SOURCEADDRESS_ERROR);
            }
            String masterWeight = accountSetPrivilegeOperation.getMasterWeight();
            if (!(Tools.isEmpty(masterWeight).booleanValue() || (isNumber2 = (pattern2 = Pattern.compile("^[-\\+]?[\\d]*$")).matcher(masterWeight).matches()) && Long.valueOf(masterWeight) >= 0L && Long.valueOf(masterWeight) <= Constant.UINT_MAX)) {
                throw new SDKException(SdkError.INVALID_MASTERWEIGHT_ERROR);
            }
            String txThreshold = accountSetPrivilegeOperation.getTxThreshold();
            if (!(Tools.isEmpty(txThreshold).booleanValue() || (isNumber = (pattern = Pattern.compile("^[-\\+]?[\\d]*$")).matcher(txThreshold).matches()) && Long.valueOf(txThreshold) >= 0L)) {
                throw new SDKException(SdkError.INVALID_TX_THRESHOLD_ERROR);
            }
            String metadata = accountSetPrivilegeOperation.getMetadata();
            Signer[] signers = accountSetPrivilegeOperation.getSigners();
            TypeThreshold[] typeThresholds = accountSetPrivilegeOperation.getTypeThresholds();
            operation = AccountServiceImpl.buildSetPrivilegeOperation(sourceAddress, masterWeight, txThreshold, signers, typeThresholds, metadata);
        }
        catch (SDKException sdkException) {
            throw sdkException;
        }
        catch (NumberFormatException exception) {
            throw new SDKException(SdkError.INVALID_TX_THRESHOLD_ERROR);
        }
        catch (Exception e) {
            throw new SDKException(SdkError.SYSTEM_ERROR.getCode(), e.getMessage());
        }
        return operation;
    }

    @Override
    public AccountCheckValidResponse checkValid(AccountCheckValidRequest accountCheckValidRequest) {
        boolean isValid;
        AccountCheckValidResponse accountCheckValidResponse = new AccountCheckValidResponse();
        AccountCheckValidResult accountCheckValidResult = new AccountCheckValidResult();
        try {
            isValid = PublicKey.isAddressValid((String)accountCheckValidRequest.getAddress());
        }
        catch (EncException e) {
            isValid = false;
        }
        try {
            if (null == accountCheckValidRequest) {
                throw new SDKException(SdkError.REQUEST_NULL_ERROR);
            }
            Class<?> cls = accountCheckValidResult.getClass();
            Method method = cls.getDeclaredMethod("setValid", Boolean.TYPE);
            method.setAccessible(true);
            method.invoke((Object)accountCheckValidResult, isValid);
            accountCheckValidResponse.buildResponse(SdkError.SUCCESS, accountCheckValidResult);
        }
        catch (SDKException apiException) {
            Integer errorCode = apiException.getErrorCode();
            String errorDesc = apiException.getErrorDesc();
            accountCheckValidResponse.buildResponse(errorCode, errorDesc, accountCheckValidResult);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            accountCheckValidResponse.buildResponse(SdkError.SYSTEM_ERROR.getCode(), e.getMessage(), accountCheckValidResult);
        }
        return accountCheckValidResponse;
    }

    @Override
    public AccountCreateResponse create() {
        AccountCreateResponse accountCreateResponse = new AccountCreateResponse();
        AccountCreateResult accountCreateResult = new AccountCreateResult();
        try {
            PrivateKey privateKey = new PrivateKey();
            accountCreateResult.setPrivateKey(privateKey.getEncPrivateKey());
            accountCreateResult.setPublicKey(privateKey.getEncPublicKey());
            accountCreateResult.setAddress(privateKey.getEncAddress());
            accountCreateResponse.buildResponse(SdkError.SUCCESS, accountCreateResult);
        }
        catch (Exception e) {
            accountCreateResponse.buildResponse(SdkError.ACCOUNT_CREATE_ERROR, accountCreateResult);
        }
        return accountCreateResponse;
    }

    @Override
    public AccountGetInfoResponse getInfo(AccountGetInfoRequest accountGetInfoRequest) {
        AccountGetInfoResponse accountGetInfoResponse = new AccountGetInfoResponse();
        AccountGetInfoResult accountGetInfoResult = new AccountGetInfoResult();
        try {
            if (Tools.isEmpty(accountGetInfoRequest).booleanValue()) {
                throw new SDKException(SdkError.REQUEST_NULL_ERROR);
            }
            String address = accountGetInfoRequest.getAddress();
            if (!PublicKey.isAddressValid((String)address)) {
                throw new SDKException(SdkError.INVALID_ADDRESS_ERROR);
            }
            if (Tools.isEmpty(General.getInstance().getUrl()).booleanValue()) {
                throw new SDKException(SdkError.URL_EMPTY_ERROR);
            }
            accountGetInfoResponse = AccountServiceImpl.getInfo(address);
            Integer errorCode = accountGetInfoResponse.getErrorCode();
            String errorDesc = accountGetInfoResponse.getErrorDesc();
            if (!Tools.isEmpty(errorCode).booleanValue() && errorCode == 4) {
                throw new SDKException(errorCode, null == errorDesc ? "Account (" + address + ") not exist" : errorDesc);
            }
            SdkError.checkErrorCode(accountGetInfoResponse);
        }
        catch (SDKException apiException) {
            Integer errorCode = apiException.getErrorCode();
            String errorDesc = apiException.getErrorDesc();
            accountGetInfoResponse.buildResponse(errorCode, errorDesc, accountGetInfoResult);
        }
        catch (IOException | KeyManagementException | NoSuchAlgorithmException | NoSuchProviderException e) {
            accountGetInfoResponse.buildResponse(SdkError.CONNECTNETWORK_ERROR, accountGetInfoResult);
        }
        catch (Exception e) {
            accountGetInfoResponse.buildResponse(SdkError.SYSTEM_ERROR.getCode(), e.getMessage(), accountGetInfoResult);
        }
        return accountGetInfoResponse;
    }

    @Override
    public AccountGetNonceResponse getNonce(AccountGetNonceRequest accountGetNonceRequest) {
        AccountGetNonceResponse accountGetNonceResponse = new AccountGetNonceResponse();
        AccountGetNonceResult accountGetNonceResult = new AccountGetNonceResult();
        try {
            if (Tools.isEmpty(accountGetNonceRequest).booleanValue()) {
                throw new SDKException(SdkError.REQUEST_NULL_ERROR);
            }
            String address = accountGetNonceRequest.getAddress();
            if (!PublicKey.isAddressValid((String)address)) {
                throw new SDKException(SdkError.INVALID_ADDRESS_ERROR);
            }
            if (Tools.isEmpty(General.getInstance().getUrl()).booleanValue()) {
                throw new SDKException(SdkError.URL_EMPTY_ERROR);
            }
            String accountGetInfoUrl = General.getInstance().accountGetInfoUrl(address);
            String result = HttpKit.get(accountGetInfoUrl);
            accountGetNonceResponse = (AccountGetNonceResponse)JSON.parseObject((String)result, AccountGetNonceResponse.class);
            Integer errorCode = accountGetNonceResponse.getErrorCode();
            String errorDesc = accountGetNonceResponse.getErrorDesc();
            if (!Tools.isEmpty(errorCode).booleanValue() && errorCode == 4) {
                throw new SDKException(errorCode, null == errorDesc ? "Account (" + address + ") not exist" : errorDesc);
            }
            SdkError.checkErrorCode(accountGetNonceResponse);
            if (accountGetNonceResponse.getResult().getNonce() == null) {
                accountGetNonceResponse.getResult().setNonce(0L);
            }
        }
        catch (SDKException apiException) {
            Integer errorCode = apiException.getErrorCode();
            String errorDesc = apiException.getErrorDesc();
            accountGetNonceResponse.buildResponse(errorCode, errorDesc, accountGetNonceResult);
        }
        catch (IOException | KeyManagementException | NoSuchAlgorithmException | NoSuchProviderException e) {
            accountGetNonceResponse.buildResponse(SdkError.CONNECTNETWORK_ERROR, accountGetNonceResult);
        }
        catch (Exception e) {
            accountGetNonceResponse.buildResponse(SdkError.SYSTEM_ERROR.getCode(), e.getMessage(), accountGetNonceResult);
        }
        return accountGetNonceResponse;
    }

    @Override
    public AccountGetBalanceResponse getBalance(AccountGetBalanceRequest accountGetBalanceRequest) {
        AccountGetBalanceResponse accountGetBalanceResponse = new AccountGetBalanceResponse();
        AccountGetBalanceResult accountGetBalanceResult = new AccountGetBalanceResult();
        try {
            if (Tools.isEmpty(accountGetBalanceRequest).booleanValue()) {
                throw new SDKException(SdkError.REQUEST_NULL_ERROR);
            }
            String address = accountGetBalanceRequest.getAddress();
            if (!PublicKey.isAddressValid((String)address)) {
                throw new SDKException(SdkError.INVALID_ADDRESS_ERROR);
            }
            if (Tools.isEmpty(General.getInstance().getUrl()).booleanValue()) {
                throw new SDKException(SdkError.URL_EMPTY_ERROR);
            }
            String accountGetInfoUrl = General.getInstance().accountGetInfoUrl(address);
            String result = HttpKit.get(accountGetInfoUrl);
            accountGetBalanceResponse = (AccountGetBalanceResponse)JSON.parseObject((String)result, AccountGetBalanceResponse.class);
            Integer errorCode = accountGetBalanceResponse.getErrorCode();
            String errorDesc = accountGetBalanceResponse.getErrorDesc();
            if (!Tools.isEmpty(errorCode).booleanValue() && errorCode == 4) {
                throw new SDKException(errorCode, null == errorDesc ? "Account (" + address + ") not exist" : errorDesc);
            }
            SdkError.checkErrorCode(accountGetBalanceResponse);
        }
        catch (SDKException apiException) {
            Integer errorCode = apiException.getErrorCode();
            String errorDesc = apiException.getErrorDesc();
            accountGetBalanceResponse.buildResponse(errorCode, errorDesc, accountGetBalanceResult);
        }
        catch (IOException | KeyManagementException | NoSuchAlgorithmException | NoSuchProviderException e) {
            accountGetBalanceResponse.buildResponse(SdkError.CONNECTNETWORK_ERROR, accountGetBalanceResult);
        }
        catch (Exception e) {
            accountGetBalanceResponse.buildResponse(SdkError.SYSTEM_ERROR.getCode(), e.getMessage(), accountGetBalanceResult);
        }
        return accountGetBalanceResponse;
    }

    @Override
    public AccountGetAssetsResponse getAssets(AccountGetAssetsRequest accountGetAssetsRequest) {
        AccountGetAssetsResponse accountGetAssetsResponse = new AccountGetAssetsResponse();
        AccountGetAssetsResult accountGetAssetsResult = new AccountGetAssetsResult();
        try {
            if (Tools.isEmpty(accountGetAssetsRequest).booleanValue()) {
                throw new SDKException(SdkError.REQUEST_NULL_ERROR);
            }
            String address = accountGetAssetsRequest.getAddress();
            if (!PublicKey.isAddressValid((String)address)) {
                throw new SDKException(SdkError.INVALID_ADDRESS_ERROR);
            }
            if (Tools.isEmpty(General.getInstance().getUrl()).booleanValue()) {
                throw new SDKException(SdkError.URL_EMPTY_ERROR);
            }
            String accountGetInfoUrl = General.getInstance().accountGetAssetsUrl(address);
            String result = HttpKit.get(accountGetInfoUrl);
            accountGetAssetsResponse = (AccountGetAssetsResponse)JSON.parseObject((String)result, AccountGetAssetsResponse.class);
            Integer errorCode = accountGetAssetsResponse.getErrorCode();
            String errorDesc = accountGetAssetsResponse.getErrorDesc();
            if (!Tools.isEmpty(errorCode).booleanValue() && errorCode == 4) {
                throw new SDKException(errorCode, null == errorDesc ? "Account (" + address + ") not exist" : errorDesc);
            }
            SdkError.checkErrorCode(accountGetAssetsResponse);
            Object[] assetInfos = accountGetAssetsResponse.getResult().getAssets();
            if (Tools.isEmpty(assetInfos).booleanValue()) {
                throw new SDKException(SdkError.NO_ASSET_ERROR);
            }
        }
        catch (SDKException apiException) {
            Integer errorCode = apiException.getErrorCode();
            String errorDesc = apiException.getErrorDesc();
            accountGetAssetsResponse.buildResponse(errorCode, errorDesc, accountGetAssetsResult);
        }
        catch (IOException | KeyManagementException | NoSuchAlgorithmException | NoSuchProviderException e) {
            accountGetAssetsResponse.buildResponse(SdkError.CONNECTNETWORK_ERROR, accountGetAssetsResult);
        }
        catch (Exception e) {
            accountGetAssetsResponse.buildResponse(SdkError.SYSTEM_ERROR.getCode(), e.getMessage(), accountGetAssetsResult);
        }
        return accountGetAssetsResponse;
    }

    @Override
    public AccountGetMetadataResponse getMetadata(AccountGetMetadataRequest accountGetMetadataRequest) {
        AccountGetMetadataResponse accountGetMetadataResponse = new AccountGetMetadataResponse();
        AccountGetMetadataResult accountGetMetadataResult = new AccountGetMetadataResult();
        try {
            if (Tools.isEmpty(accountGetMetadataRequest).booleanValue()) {
                throw new SDKException(SdkError.REQUEST_NULL_ERROR);
            }
            String address = accountGetMetadataRequest.getAddress();
            if (!PublicKey.isAddressValid((String)address)) {
                throw new SDKException(SdkError.INVALID_ADDRESS_ERROR);
            }
            String key = accountGetMetadataRequest.getKey();
            if (!(Tools.isNULL(key).booleanValue() || (long)key.length() <= Constant.METADATA_KEY_MAX && key.length() >= 1)) {
                throw new SDKException(SdkError.INVALID_DATAKEY_ERROR);
            }
            if (Tools.isEmpty(General.getInstance().getUrl()).booleanValue()) {
                throw new SDKException(SdkError.URL_EMPTY_ERROR);
            }
            String accountGetInfoUrl = General.getInstance().accountGetMetadataUrl(address, key);
            String result = HttpKit.get(accountGetInfoUrl);
            accountGetMetadataResponse = (AccountGetMetadataResponse)JSON.parseObject((String)result, AccountGetMetadataResponse.class);
            Integer errorCode = accountGetMetadataResponse.getErrorCode();
            String errorDesc = accountGetMetadataResponse.getErrorDesc();
            if (!Tools.isEmpty(errorCode).booleanValue() && errorCode == 4) {
                throw new SDKException(errorCode, null == errorDesc ? "Account (" + address + ") not exist" : errorDesc);
            }
            SdkError.checkErrorCode(accountGetMetadataResponse);
            Object[] metadataInfos = accountGetMetadataResponse.getResult().getMetadatas();
            if (Tools.isEmpty(metadataInfos).booleanValue()) {
                throw new SDKException(SdkError.NO_METADATA_ERROR);
            }
        }
        catch (SDKException apiException) {
            Integer errorCode = apiException.getErrorCode();
            String errorDesc = apiException.getErrorDesc();
            accountGetMetadataResponse.buildResponse(errorCode, errorDesc, accountGetMetadataResult);
        }
        catch (IOException | KeyManagementException | NoSuchAlgorithmException | NoSuchProviderException e) {
            accountGetMetadataResponse.buildResponse(SdkError.CONNECTNETWORK_ERROR, accountGetMetadataResult);
        }
        catch (Exception e) {
            accountGetMetadataResponse.buildResponse(SdkError.SYSTEM_ERROR.getCode(), e.getMessage(), accountGetMetadataResult);
        }
        return accountGetMetadataResponse;
    }

    @Override
    public AccountCheckActivatedResponse checkActivated(AccountCheckActivatedRequst accountCheckActivatedRequst) {
        AccountCheckActivatedResponse accountCheckActivatedResponse = new AccountCheckActivatedResponse();
        AccountCheckActivatedResult accountCheckActivatedResult = new AccountCheckActivatedResult();
        try {
            if (Tools.isEmpty(accountCheckActivatedRequst).booleanValue()) {
                throw new SDKException(SdkError.REQUEST_NULL_ERROR);
            }
            String address = accountCheckActivatedRequst.getAddress();
            if (!PublicKey.isAddressValid((String)address)) {
                throw new SDKException(SdkError.INVALID_ADDRESS_ERROR);
            }
            if (Tools.isEmpty(General.getInstance().getUrl()).booleanValue()) {
                throw new SDKException(SdkError.URL_EMPTY_ERROR);
            }
            accountCheckActivatedResult.setIsActivated(AccountServiceImpl.isActivated(address));
            accountCheckActivatedResponse.buildResponse(SdkError.SUCCESS, accountCheckActivatedResult);
        }
        catch (SDKException apiException) {
            Integer errorCode = apiException.getErrorCode();
            String errorDesc = apiException.getErrorDesc();
            accountCheckActivatedResponse.buildResponse(errorCode, errorDesc, accountCheckActivatedResult);
        }
        catch (IOException | KeyManagementException | NoSuchAlgorithmException | NoSuchProviderException e) {
            accountCheckActivatedResponse.buildResponse(SdkError.CONNECTNETWORK_ERROR, accountCheckActivatedResult);
        }
        catch (Exception e) {
            accountCheckActivatedResponse.buildResponse(SdkError.SYSTEM_ERROR.getCode(), e.getMessage(), accountCheckActivatedResult);
        }
        return accountCheckActivatedResponse;
    }

    public static Chain.Operation buildActivateOperation(String sourceAddress, String destAddress, Long initBalance, String metadata) {
        Chain.Operation.Builder operation = Chain.Operation.newBuilder();
        operation.setType(Chain.Operation.Type.CREATE_ACCOUNT);
        if (!Tools.isEmpty(sourceAddress).booleanValue()) {
            operation.setSourceAddress(sourceAddress);
        }
        if (!Tools.isEmpty(metadata).booleanValue()) {
            operation.setMetadata(ByteString.copyFromUtf8((String)metadata));
        }
        Chain.OperationCreateAccount.Builder operationCreateAccount = operation.getCreateAccountBuilder();
        operationCreateAccount.setDestAddress(destAddress);
        operationCreateAccount.setInitBalance(initBalance);
        Chain.AccountPrivilege.Builder accountPrivilege = operationCreateAccount.getPrivBuilder();
        accountPrivilege.setMasterWeight(1L);
        Chain.AccountThreshold.Builder accountThreshold = accountPrivilege.getThresholdsBuilder();
        accountThreshold.setTxThreshold(1L);
        return operation.build();
    }

    public static Chain.Operation buildSetPrivilegeOperation(String sourceAddress, String masterWeight, String txThreshold, Signer[] signers, TypeThreshold[] typeThresholds, String metadata) {
        Chain.Operation.Builder operation = Chain.Operation.newBuilder();
        operation.setType(Chain.Operation.Type.SET_PRIVILEGE);
        if (!Tools.isEmpty(sourceAddress).booleanValue()) {
            operation.setSourceAddress(sourceAddress);
        }
        if (!Tools.isEmpty(metadata).booleanValue()) {
            operation.setMetadata(ByteString.copyFromUtf8((String)metadata));
        }
        Chain.OperationSetPrivilege.Builder operationSetPrivilege = operation.getSetPrivilegeBuilder();
        if (!Tools.isEmpty(masterWeight).booleanValue()) {
            operationSetPrivilege.setMasterWeight(masterWeight);
        }
        if (!Tools.isEmpty(txThreshold).booleanValue()) {
            operationSetPrivilege.setTxThreshold(txThreshold);
        }
        if (!Tools.isEmpty(signers).booleanValue()) {
            int signersLength = signers.length;
            for (int i = 0; i < signersLength; ++i) {
                Signer signer = signers[i];
                String signerAddress = signer.getAddress();
                if (!PublicKey.isAddressValid((String)signerAddress)) {
                    throw new SDKException(SdkError.INVALID_SIGNER_ADDRESS_ERROR);
                }
                Long signerWeight = signer.getWeight();
                if (Tools.isEmpty(signerWeight).booleanValue() || signerWeight < 0L || signerWeight > Constant.UINT_MAX) {
                    throw new SDKException(SdkError.INVALID_SIGNER_WEIGHT_ERROR);
                }
                Chain.Signer.Builder signerBuilder = operationSetPrivilege.addSignersBuilder();
                signerBuilder.setAddress(signerAddress);
                signerBuilder.setWeight(signerWeight);
            }
        }
        if (!Tools.isEmpty(typeThresholds).booleanValue()) {
            for (TypeThreshold typeThreshold : typeThresholds) {
                Integer type = typeThreshold.getType();
                if (Tools.isEmpty(type).booleanValue() || type < 1) {
                    throw new SDKException(SdkError.INVALID_TYPETHRESHOLD_TYPE_ERROR);
                }
                Long threshold = typeThreshold.getThreshold();
                if (Tools.isEmpty(threshold).booleanValue() || threshold < 0L) {
                    throw new SDKException(SdkError.INVALID_TYPE_THRESHOLD_ERROR);
                }
                Chain.OperationTypeThreshold.Builder typeThresholdBuilder = operationSetPrivilege.addTypeThresholdsBuilder();
                Chain.Operation.Type operationType = Chain.Operation.Type.forNumber(type);
                if (Tools.isEmpty((Object)operationType).booleanValue()) {
                    throw new SDKException(SdkError.INVALID_TYPETHRESHOLD_TYPE_ERROR);
                }
                typeThresholdBuilder.setType(operationType);
                typeThresholdBuilder.setThreshold(threshold);
            }
        }
        return operation.build();
    }

    public static Boolean isActivated(String address) throws KeyManagementException, NoSuchAlgorithmException, NoSuchProviderException, IOException {
        AccountGetInfoResponse accountGetInfoResponse = AccountServiceImpl.getInfo(address);
        Integer errorCode = accountGetInfoResponse.getErrorCode();
        if (!Tools.isEmpty(errorCode).booleanValue() && errorCode == 4) {
            return false;
        }
        SdkError.checkErrorCode(accountGetInfoResponse);
        return true;
    }

    private static AccountGetInfoResponse getInfo(String address) throws IOException, KeyManagementException, NoSuchAlgorithmException, NoSuchProviderException {
        String accountGetInfoUrl = General.getInstance().accountGetInfoUrl(address);
        String result = HttpKit.get(accountGetInfoUrl);
        return (AccountGetInfoResponse)JSON.parseObject((String)result, AccountGetInfoResponse.class);
    }
}

