/*
 * Decompiled with CFR 0.152.
 */
package cn.bubi.blockchain.impl;

import cn.bubi.blockchain.BlockService;
import cn.bubi.common.General;
import cn.bubi.common.Tools;
import cn.bubi.crypto.http.HttpKit;
import cn.bubi.exception.SDKException;
import cn.bubi.exception.SdkError;
import cn.bubi.model.request.BlockGetFeesRequest;
import cn.bubi.model.request.BlockGetInfoRequest;
import cn.bubi.model.request.BlockGetRewardRequest;
import cn.bubi.model.request.BlockGetTransactionsRequest;
import cn.bubi.model.request.BlockGetValidatorsRequest;
import cn.bubi.model.response.BlockCheckStatusLedgerSeqResponse;
import cn.bubi.model.response.BlockCheckStatusResponse;
import cn.bubi.model.response.BlockGetFeesResponse;
import cn.bubi.model.response.BlockGetInfoResponse;
import cn.bubi.model.response.BlockGetLatestFeesResponse;
import cn.bubi.model.response.BlockGetLatestInfoResponse;
import cn.bubi.model.response.BlockGetLatestRewardResponse;
import cn.bubi.model.response.BlockGetLatestValidatorsResponse;
import cn.bubi.model.response.BlockGetNumberResponse;
import cn.bubi.model.response.BlockGetRewardResponse;
import cn.bubi.model.response.BlockGetTransactionsResponse;
import cn.bubi.model.response.BlockGetValidatorsResponse;
import cn.bubi.model.response.ContractCallResponse;
import cn.bubi.model.response.result.BlockCheckStatusResult;
import cn.bubi.model.response.result.BlockGetFeesResult;
import cn.bubi.model.response.result.BlockGetInfoResult;
import cn.bubi.model.response.result.BlockGetLatestFeesResult;
import cn.bubi.model.response.result.BlockGetLatestInfoResult;
import cn.bubi.model.response.result.BlockGetLatestRewardResult;
import cn.bubi.model.response.result.BlockGetLatestValidatorsResult;
import cn.bubi.model.response.result.BlockGetNumberResult;
import cn.bubi.model.response.result.BlockGetRewardResult;
import cn.bubi.model.response.result.BlockGetTransactionsResult;
import cn.bubi.model.response.result.BlockGetValidatorsResult;
import cn.bubi.model.response.result.data.LedgerSeq;
import cn.bubi.model.response.result.data.Rewards;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Map;

public class BlockServiceImpl
implements BlockService {
    @Override
    public BlockGetNumberResponse getNumber() {
        BlockGetNumberResponse blockGetNumberResponse = new BlockGetNumberResponse();
        BlockGetNumberResult blockGetNumberResult = new BlockGetNumberResult();
        try {
            if (Tools.isEmpty(General.getInstance().getUrl()).booleanValue()) {
                throw new SDKException(SdkError.URL_EMPTY_ERROR);
            }
            String getNumberUrl = General.getInstance().blockGetNumberUrl();
            String result = HttpKit.get(getNumberUrl);
            blockGetNumberResponse = (BlockGetNumberResponse)JSONObject.parseObject((String)result, BlockGetNumberResponse.class);
        }
        catch (IOException | KeyManagementException | NoSuchAlgorithmException | NoSuchProviderException e) {
            blockGetNumberResponse.buildResponse(SdkError.CONNECTNETWORK_ERROR, blockGetNumberResult);
        }
        catch (Exception e) {
            blockGetNumberResponse.buildResponse(SdkError.SYSTEM_ERROR.getCode(), e.getMessage(), blockGetNumberResult);
        }
        return blockGetNumberResponse;
    }

    @Override
    public BlockCheckStatusResponse checkStatus() {
        BlockCheckStatusResponse blockCheckStatusResponse = new BlockCheckStatusResponse();
        BlockCheckStatusResult blockCheckStatusResult = new BlockCheckStatusResult();
        try {
            if (Tools.isEmpty(General.getInstance().getUrl()).booleanValue()) {
                throw new SDKException(SdkError.URL_EMPTY_ERROR);
            }
            String checkStatusUrl = General.getInstance().blockCheckStatusUrl();
            String result = HttpKit.get(checkStatusUrl);
            BlockCheckStatusLedgerSeqResponse blockCheckStatusLedgerSeqResponse = (BlockCheckStatusLedgerSeqResponse)JSONObject.parseObject((String)result, BlockCheckStatusLedgerSeqResponse.class);
            if (blockCheckStatusLedgerSeqResponse == null) {
                throw new SDKException(SdkError.CONNECTNETWORK_ERROR);
            }
            LedgerSeq ledgerSeq = blockCheckStatusLedgerSeqResponse.getLedgerSeq();
            if (ledgerSeq.getLedgerSequence() < ledgerSeq.getChainMaxLedgerSeq()) {
                blockCheckStatusResult.setSynchronous(false);
            } else {
                blockCheckStatusResult.setSynchronous(true);
            }
            blockCheckStatusResponse.buildResponse(SdkError.SUCCESS, blockCheckStatusResult);
        }
        catch (SDKException apiException) {
            Integer errorCode = apiException.getErrorCode();
            String errorDesc = apiException.getErrorDesc();
            blockCheckStatusResponse.buildResponse(errorCode, errorDesc, blockCheckStatusResult);
        }
        catch (IOException | KeyManagementException | NoSuchAlgorithmException | NoSuchProviderException e) {
            blockCheckStatusResponse.buildResponse(SdkError.CONNECTNETWORK_ERROR, blockCheckStatusResult);
        }
        catch (Exception e) {
            blockCheckStatusResponse.buildResponse(SdkError.SYSTEM_ERROR.getCode(), e.getMessage(), blockCheckStatusResult);
        }
        return blockCheckStatusResponse;
    }

    @Override
    public BlockGetTransactionsResponse getTransactions(BlockGetTransactionsRequest blockGetTransactionsRequest) {
        BlockGetTransactionsResponse blockGetTransactions = new BlockGetTransactionsResponse();
        BlockGetTransactionsResult transactionGetInfoResult = new BlockGetTransactionsResult();
        try {
            if (Tools.isEmpty(General.getInstance().getUrl()).booleanValue()) {
                throw new SDKException(SdkError.URL_EMPTY_ERROR);
            }
            if (Tools.isEmpty(blockGetTransactionsRequest).booleanValue()) {
                throw new SDKException(SdkError.REQUEST_NULL_ERROR);
            }
            Long blockNumber = blockGetTransactionsRequest.getBlockNumber();
            if (Tools.isEmpty(blockNumber).booleanValue() || blockNumber < 1L) {
                throw new SDKException(SdkError.INVALID_BLOCKNUMBER_ERROR);
            }
            String getTransactionsUrl = General.getInstance().blockGetTransactionsUrl(blockNumber);
            String result = HttpKit.get(getTransactionsUrl);
            blockGetTransactions = (BlockGetTransactionsResponse)JSONObject.parseObject((String)result, BlockGetTransactionsResponse.class);
        }
        catch (SDKException apiException) {
            Integer errorCode = apiException.getErrorCode();
            String errorDesc = apiException.getErrorDesc();
            blockGetTransactions.buildResponse(errorCode, errorDesc, transactionGetInfoResult);
        }
        catch (IOException | KeyManagementException | NoSuchAlgorithmException | NoSuchProviderException e) {
            blockGetTransactions.buildResponse(SdkError.CONNECTNETWORK_ERROR, transactionGetInfoResult);
        }
        catch (Exception e) {
            blockGetTransactions.buildResponse(SdkError.SYSTEM_ERROR.getCode(), e.getMessage(), transactionGetInfoResult);
        }
        return blockGetTransactions;
    }

    @Override
    public BlockGetInfoResponse getInfo(BlockGetInfoRequest blockGetInfoRequest) {
        BlockGetInfoResponse blockGetInfoResponse = new BlockGetInfoResponse();
        BlockGetInfoResult blockGetInfoResult = new BlockGetInfoResult();
        try {
            if (Tools.isEmpty(General.getInstance().getUrl()).booleanValue()) {
                throw new SDKException(SdkError.URL_EMPTY_ERROR);
            }
            if (Tools.isEmpty(blockGetInfoRequest).booleanValue()) {
                throw new SDKException(SdkError.REQUEST_NULL_ERROR);
            }
            Long blockNumber = blockGetInfoRequest.getBlockNumber();
            if (Tools.isEmpty(blockNumber).booleanValue() || blockNumber < 1L) {
                throw new SDKException(SdkError.INVALID_BLOCKNUMBER_ERROR);
            }
            String getInfoUrl = General.getInstance().blockGetInfoUrl(blockNumber);
            String result = HttpKit.get(getInfoUrl);
            blockGetInfoResponse = (BlockGetInfoResponse)JSONObject.parseObject((String)result, BlockGetInfoResponse.class);
            Integer errorCode = blockGetInfoResponse.getErrorCode();
            String errorDesc = blockGetInfoResponse.getErrorDesc();
            if (!Tools.isEmpty(errorCode).booleanValue() && errorCode == 4) {
                throw new SDKException(4, Tools.isEmpty(errorDesc) != false ? "Block (" + blockNumber + ") does not exist" : errorDesc);
            }
            SdkError.checkErrorCode(blockGetInfoResponse);
        }
        catch (SDKException apiException) {
            Integer errorCode = apiException.getErrorCode();
            String errorDesc = apiException.getErrorDesc();
            blockGetInfoResponse.buildResponse(errorCode, errorDesc, blockGetInfoResult);
        }
        catch (IOException | KeyManagementException | NoSuchAlgorithmException | NoSuchProviderException e) {
            blockGetInfoResponse.buildResponse(SdkError.CONNECTNETWORK_ERROR, blockGetInfoResult);
        }
        catch (Exception e) {
            blockGetInfoResponse.buildResponse(SdkError.SYSTEM_ERROR.getCode(), e.getMessage(), blockGetInfoResult);
        }
        return blockGetInfoResponse;
    }

    @Override
    public BlockGetLatestInfoResponse getLatestInfo() {
        BlockGetLatestInfoResponse blockGetLatestInfoResponse = new BlockGetLatestInfoResponse();
        BlockGetLatestInfoResult blockGetLatestInfoResult = new BlockGetLatestInfoResult();
        try {
            if (Tools.isEmpty(General.getInstance().getUrl()).booleanValue()) {
                throw new SDKException(SdkError.URL_EMPTY_ERROR);
            }
            String getInfoUrl = General.getInstance().blockGetLatestInfoUrl();
            String result = HttpKit.get(getInfoUrl);
            blockGetLatestInfoResponse = (BlockGetLatestInfoResponse)JSONObject.parseObject((String)result, BlockGetLatestInfoResponse.class);
        }
        catch (SDKException apiException) {
            Integer errorCode = apiException.getErrorCode();
            String errorDesc = apiException.getErrorDesc();
            blockGetLatestInfoResponse.buildResponse(errorCode, errorDesc, blockGetLatestInfoResult);
        }
        catch (IOException | KeyManagementException | NoSuchAlgorithmException | NoSuchProviderException e) {
            blockGetLatestInfoResponse.buildResponse(SdkError.CONNECTNETWORK_ERROR, blockGetLatestInfoResult);
        }
        catch (Exception e) {
            blockGetLatestInfoResponse.buildResponse(SdkError.SYSTEM_ERROR.getCode(), e.getMessage(), blockGetLatestInfoResult);
        }
        return blockGetLatestInfoResponse;
    }

    @Override
    public BlockGetValidatorsResponse getValidators(BlockGetValidatorsRequest blockGetValidatorsRequest) {
        BlockGetValidatorsResponse blockGetValidatorsResponse = new BlockGetValidatorsResponse();
        BlockGetValidatorsResult blockGetValidatorsResult = new BlockGetValidatorsResult();
        try {
            if (Tools.isEmpty(General.getInstance().getUrl()).booleanValue()) {
                throw new SDKException(SdkError.URL_EMPTY_ERROR);
            }
            if (Tools.isEmpty(blockGetValidatorsRequest).booleanValue()) {
                throw new SDKException(SdkError.REQUEST_NULL_ERROR);
            }
            Long blockNumber = blockGetValidatorsRequest.getBlockNumber();
            if (Tools.isEmpty(blockNumber).booleanValue() || blockNumber < 1L) {
                throw new SDKException(SdkError.INVALID_BLOCKNUMBER_ERROR);
            }
            String getInfoUrl = General.getInstance().blockGetValidatorsUrl(blockNumber);
            String result = HttpKit.get(getInfoUrl);
            blockGetValidatorsResponse = (BlockGetValidatorsResponse)JSONObject.parseObject((String)result, BlockGetValidatorsResponse.class);
            Integer errorCode = blockGetValidatorsResponse.getErrorCode();
            String errorDesc = blockGetValidatorsResponse.getErrorDesc();
            if (!Tools.isEmpty(errorCode).booleanValue() && errorCode == 4) {
                throw new SDKException(4, Tools.isEmpty(errorDesc) != false ? "Block (" + blockNumber + ") does not exist" : errorDesc);
            }
            SdkError.checkErrorCode(blockGetValidatorsResponse);
        }
        catch (SDKException apiException) {
            Integer errorCode = apiException.getErrorCode();
            String errorDesc = apiException.getErrorDesc();
            blockGetValidatorsResponse.buildResponse(errorCode, errorDesc, blockGetValidatorsResult);
        }
        catch (IOException | KeyManagementException | NoSuchAlgorithmException | NoSuchProviderException e) {
            blockGetValidatorsResponse.buildResponse(SdkError.CONNECTNETWORK_ERROR, blockGetValidatorsResult);
        }
        catch (Exception e) {
            blockGetValidatorsResponse.buildResponse(SdkError.SYSTEM_ERROR.getCode(), e.getMessage(), blockGetValidatorsResult);
        }
        return blockGetValidatorsResponse;
    }

    @Override
    public BlockGetLatestValidatorsResponse getLatestValidators() {
        BlockGetLatestValidatorsResponse blockGetLatestValidatorsResponse = new BlockGetLatestValidatorsResponse();
        BlockGetLatestValidatorsResult blockGetLatestValidatorsResult = new BlockGetLatestValidatorsResult();
        try {
            if (Tools.isEmpty(General.getInstance().getUrl()).booleanValue()) {
                throw new SDKException(SdkError.URL_EMPTY_ERROR);
            }
            String getInfoUrl = General.getInstance().blockGetLatestValidatorsUrl();
            String result = HttpKit.get(getInfoUrl);
            blockGetLatestValidatorsResponse = (BlockGetLatestValidatorsResponse)JSONObject.parseObject((String)result, BlockGetLatestValidatorsResponse.class);
            SdkError.checkErrorCode(blockGetLatestValidatorsResponse);
        }
        catch (SDKException apiException) {
            Integer errorCode = apiException.getErrorCode();
            String errorDesc = apiException.getErrorDesc();
            blockGetLatestValidatorsResponse.buildResponse(errorCode, errorDesc, blockGetLatestValidatorsResult);
        }
        catch (IOException | KeyManagementException | NoSuchAlgorithmException | NoSuchProviderException e) {
            blockGetLatestValidatorsResponse.buildResponse(SdkError.CONNECTNETWORK_ERROR, blockGetLatestValidatorsResult);
        }
        catch (Exception e) {
            blockGetLatestValidatorsResponse.buildResponse(SdkError.SYSTEM_ERROR.getCode(), e.getMessage(), blockGetLatestValidatorsResult);
        }
        return blockGetLatestValidatorsResponse;
    }

    @Override
    public BlockGetRewardResponse getReward(BlockGetRewardRequest blockGetRewardRequest) {
        BlockGetRewardResponse blockGetRewardResponse = new BlockGetRewardResponse();
        BlockGetRewardResult blockGetRewardResult = new BlockGetRewardResult();
        try {
            if (Tools.isEmpty(General.getInstance().getUrl()).booleanValue()) {
                throw new SDKException(SdkError.URL_EMPTY_ERROR);
            }
            if (Tools.isEmpty(blockGetRewardRequest).booleanValue()) {
                throw new SDKException(SdkError.REQUEST_NULL_ERROR);
            }
            Long blockNumber = blockGetRewardRequest.getBlockNumber();
            if (Tools.isEmpty(blockNumber).booleanValue() || blockNumber < 1L) {
                throw new SDKException(SdkError.INVALID_BLOCKNUMBER_ERROR);
            }
            JSONObject input = new JSONObject();
            input.put("method", (Object)"getRewardDistribute");
            JSONObject params = new JSONObject();
            params.put("opt_type", (Object)2);
            params.put("fee_limit", (Object)1000000000L);
            params.put("contract_address", (Object)"adxSmrzvnbzSp1zXF26kuJCZ6hJbFYydPpBzX");
            params.put("input", (Object)input.toJSONString());
            String contractCallUrl = General.getInstance().contractCallUrl();
            String result = HttpKit.post(contractCallUrl, params.toJSONString());
            ContractCallResponse callResp = (ContractCallResponse)JSONObject.parseObject((String)result, ContractCallResponse.class);
            if (callResp.getErrorCode() == 0) {
                String value = callResp.getResult().getQueryRets().getJSONObject(0).getJSONObject("result").getString("value");
                JSONObject valueJson = JSONObject.parseObject((String)value);
                JSONObject validators = valueJson.getJSONObject("rewards").getJSONObject("validators");
                JSONObject kols = valueJson.getJSONObject("rewards").getJSONObject("kols");
                for (Map.Entry entry : validators.entrySet()) {
                    Rewards validatorObj = new Rewards();
                    validatorObj.setAddress((String)entry.getKey());
                    validatorObj.setReward((JSONArray)entry.getValue());
                    blockGetRewardResult.addValidator(validatorObj);
                }
                for (Map.Entry entry : kols.entrySet()) {
                    Rewards kolObj = new Rewards();
                    kolObj.setAddress((String)entry.getKey());
                    kolObj.setReward((JSONArray)entry.getValue());
                    blockGetRewardResult.addKol(kolObj);
                }
                blockGetRewardResponse.buildResponse(SdkError.SUCCESS, blockGetRewardResult);
            } else {
                blockGetRewardResponse.buildResponse(callResp.getErrorCode(), callResp.getErrorDesc());
            }
        }
        catch (SDKException apiException) {
            Integer errorCode = apiException.getErrorCode();
            String errorDesc = apiException.getErrorDesc();
            blockGetRewardResponse.buildResponse(errorCode, errorDesc, blockGetRewardResult);
        }
        catch (IOException | KeyManagementException | NoSuchAlgorithmException | NoSuchProviderException e) {
            blockGetRewardResponse.buildResponse(SdkError.CONNECTNETWORK_ERROR, blockGetRewardResult);
        }
        catch (Exception e) {
            blockGetRewardResponse.buildResponse(SdkError.SYSTEM_ERROR.getCode(), e.getMessage(), blockGetRewardResult);
        }
        return blockGetRewardResponse;
    }

    @Override
    public BlockGetLatestRewardResponse getLatestReward() {
        BlockGetLatestRewardResponse blockGetLatestRewardResponse = new BlockGetLatestRewardResponse();
        BlockGetLatestRewardResult blockGetLatestRewardResult = new BlockGetLatestRewardResult();
        try {
            if (Tools.isEmpty(General.getInstance().getUrl()).booleanValue()) {
                throw new SDKException(SdkError.URL_EMPTY_ERROR);
            }
            JSONObject input = new JSONObject();
            input.put("method", (Object)"getRewardDistribute");
            JSONObject params = new JSONObject();
            params.put("opt_type", (Object)2);
            params.put("fee_limit", (Object)1000000000L);
            params.put("contract_address", (Object)"adxSmrzvnbzSp1zXF26kuJCZ6hJbFYydPpBzX");
            params.put("input", (Object)input.toJSONString());
            String contractCallUrl = General.getInstance().contractCallUrl();
            String result = HttpKit.post(contractCallUrl, params.toJSONString());
            ContractCallResponse callResp = (ContractCallResponse)JSONObject.parseObject((String)result, ContractCallResponse.class);
            if (callResp.getErrorCode() == 0) {
                String value = callResp.getResult().getQueryRets().getJSONObject(0).getJSONObject("result").getString("value");
                JSONObject valueJson = JSONObject.parseObject((String)value);
                JSONObject validators = valueJson.getJSONObject("rewards").getJSONObject("validators");
                JSONObject kols = valueJson.getJSONObject("rewards").getJSONObject("kols");
                for (Map.Entry entry : validators.entrySet()) {
                    Rewards validatorObj = new Rewards();
                    validatorObj.setAddress((String)entry.getKey());
                    validatorObj.setReward((JSONArray)entry.getValue());
                    blockGetLatestRewardResult.addValidator(validatorObj);
                }
                for (Map.Entry entry : kols.entrySet()) {
                    Rewards kolObj = new Rewards();
                    kolObj.setAddress((String)entry.getKey());
                    kolObj.setReward((JSONArray)entry.getValue());
                    blockGetLatestRewardResult.addKol(kolObj);
                }
                blockGetLatestRewardResponse.buildResponse(SdkError.SUCCESS, blockGetLatestRewardResult);
            } else {
                blockGetLatestRewardResponse.buildResponse(callResp.getErrorCode(), callResp.getErrorDesc());
            }
        }
        catch (SDKException apiException) {
            Integer errorCode = apiException.getErrorCode();
            String errorDesc = apiException.getErrorDesc();
            blockGetLatestRewardResponse.buildResponse(errorCode, errorDesc, blockGetLatestRewardResult);
        }
        catch (IOException | KeyManagementException | NoSuchAlgorithmException | NoSuchProviderException e) {
            blockGetLatestRewardResponse.buildResponse(SdkError.CONNECTNETWORK_ERROR, blockGetLatestRewardResult);
        }
        catch (Exception e) {
            blockGetLatestRewardResponse.buildResponse(SdkError.SYSTEM_ERROR.getCode(), e.getMessage(), blockGetLatestRewardResult);
        }
        return blockGetLatestRewardResponse;
    }

    @Override
    public BlockGetFeesResponse getFees(BlockGetFeesRequest blockGetFeesRequest) {
        BlockGetFeesResponse blockGetFeesResponse = new BlockGetFeesResponse();
        BlockGetFeesResult blockGetFeesResult = new BlockGetFeesResult();
        try {
            if (Tools.isEmpty(General.getInstance().getUrl()).booleanValue()) {
                throw new SDKException(SdkError.URL_EMPTY_ERROR);
            }
            if (Tools.isEmpty(blockGetFeesRequest).booleanValue()) {
                throw new SDKException(SdkError.REQUEST_NULL_ERROR);
            }
            Long blockNumber = blockGetFeesRequest.getBlockNumber();
            if (Tools.isEmpty(blockNumber).booleanValue() || blockNumber < 1L) {
                throw new SDKException(SdkError.INVALID_BLOCKNUMBER_ERROR);
            }
            String blockGetFeesUrl = General.getInstance().blockGetFeesUrl(blockNumber);
            String result = HttpKit.get(blockGetFeesUrl);
            blockGetFeesResponse = (BlockGetFeesResponse)JSON.parseObject((String)result, BlockGetFeesResponse.class);
            Integer errorCode = blockGetFeesResponse.getErrorCode();
            String errorDesc = blockGetFeesResponse.getErrorDesc();
            if (!Tools.isEmpty(errorCode).booleanValue() && errorCode == 4) {
                throw new SDKException(4, Tools.isEmpty(errorDesc) != false ? "Block (" + blockNumber + ") does not exist" : errorDesc);
            }
            SdkError.checkErrorCode(blockGetFeesResponse);
        }
        catch (SDKException apiException) {
            Integer errorCode = apiException.getErrorCode();
            String errorDesc = apiException.getErrorDesc();
            blockGetFeesResponse.buildResponse(errorCode, errorDesc, blockGetFeesResult);
        }
        catch (IOException | KeyManagementException | NoSuchAlgorithmException | NoSuchProviderException e) {
            blockGetFeesResponse.buildResponse(SdkError.CONNECTNETWORK_ERROR, blockGetFeesResult);
        }
        catch (Exception e) {
            blockGetFeesResponse.buildResponse(SdkError.SYSTEM_ERROR.getCode(), e.getMessage(), blockGetFeesResult);
        }
        return blockGetFeesResponse;
    }

    @Override
    public BlockGetLatestFeesResponse getLatestFees() {
        BlockGetLatestFeesResponse blockGetLatestFeesResponse = new BlockGetLatestFeesResponse();
        BlockGetLatestFeesResult blockGetLatestFeesResult = new BlockGetLatestFeesResult();
        try {
            if (Tools.isEmpty(General.getInstance().getUrl()).booleanValue()) {
                throw new SDKException(SdkError.URL_EMPTY_ERROR);
            }
            String blockGetLatestFeeUrl = General.getInstance().blockGetLatestFeeUrl();
            String result = HttpKit.get(blockGetLatestFeeUrl);
            blockGetLatestFeesResponse = (BlockGetLatestFeesResponse)JSON.parseObject((String)result, BlockGetLatestFeesResponse.class);
            SdkError.checkErrorCode(blockGetLatestFeesResponse);
        }
        catch (IOException | KeyManagementException | NoSuchAlgorithmException | NoSuchProviderException e) {
            blockGetLatestFeesResponse.buildResponse(SdkError.CONNECTNETWORK_ERROR, blockGetLatestFeesResult);
        }
        catch (Exception e) {
            blockGetLatestFeesResponse.buildResponse(SdkError.SYSTEM_ERROR.getCode(), e.getMessage(), blockGetLatestFeesResult);
        }
        return blockGetLatestFeesResponse;
    }
}

