/*
 * Decompiled with CFR 0.152.
 */
package cn.bubi.blockchain.impl;

import cn.bubi.SDK;
import cn.bubi.account.impl.AccountServiceImpl;
import cn.bubi.blockchain.TransactionService;
import cn.bubi.blockchain.impl.BlockServiceImpl;
import cn.bubi.common.Constant;
import cn.bubi.common.General;
import cn.bubi.common.OperationType;
import cn.bubi.common.Tools;
import cn.bubi.contract.impl.ContractServiceImpl;
import cn.bubi.crypto.http.HttpKit;
import cn.bubi.crypto.protobuf.Chain;
import cn.bubi.encryption.key.PrivateKey;
import cn.bubi.encryption.key.PublicKey;
import cn.bubi.encryption.utils.hash.HashUtil;
import cn.bubi.encryption.utils.hex.HexFormat;
import cn.bubi.exception.SDKException;
import cn.bubi.exception.SdkError;
import cn.bubi.log.LogServiceImpl;
import cn.bubi.model.request.TransactionBuildBlobRequest;
import cn.bubi.model.request.TransactionEvaluateFeeRequest;
import cn.bubi.model.request.TransactionGetInfoRequest;
import cn.bubi.model.request.TransactionParseBlobRequest;
import cn.bubi.model.request.TransactionSignRequest;
import cn.bubi.model.request.TransactionSubmitRequest;
import cn.bubi.model.request.operation.AccountActivateOperation;
import cn.bubi.model.request.operation.AccountSetMetadataOperation;
import cn.bubi.model.request.operation.AccountSetPrivilegeOperation;
import cn.bubi.model.request.operation.AssetIssueOperation;
import cn.bubi.model.request.operation.AssetSendOperation;
import cn.bubi.model.request.operation.BaseOperation;
import cn.bubi.model.request.operation.ContractCreateOperation;
import cn.bubi.model.request.operation.ContractInvokeByAssetOperation;
import cn.bubi.model.request.operation.ContractInvokeByGasOperation;
import cn.bubi.model.request.operation.GasSendOperation;
import cn.bubi.model.request.operation.LogCreateOperation;
import cn.bubi.model.response.BlockGetNumberResponse;
import cn.bubi.model.response.TransactionBuildBlobResponse;
import cn.bubi.model.response.TransactionEvaluateFeeResponse;
import cn.bubi.model.response.TransactionGetInfoResponse;
import cn.bubi.model.response.TransactionParseBlobResponse;
import cn.bubi.model.response.TransactionSignResponse;
import cn.bubi.model.response.TransactionSubmitHttpResponse;
import cn.bubi.model.response.TransactionSubmitResponse;
import cn.bubi.model.response.result.TransactionBuildBlobResult;
import cn.bubi.model.response.result.TransactionEvaluateFeeResult;
import cn.bubi.model.response.result.TransactionGetInfoResult;
import cn.bubi.model.response.result.TransactionParseBlobResult;
import cn.bubi.model.response.result.TransactionSignResult;
import cn.bubi.model.response.result.TransactionSubmitHttpResult;
import cn.bubi.model.response.result.TransactionSubmitResult;
import cn.bubi.model.response.result.data.Signature;
import cn.bubi.token.impl.AssetServiceImpl;
import cn.bubi.token.impl.GasServiceImpl;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.googlecode.protobuf.format.JsonFormat;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;

public class TransactionServiceImpl
implements TransactionService {
    @Override
    public TransactionBuildBlobResponse buildBlob(TransactionBuildBlobRequest transactionBuildBlobRequest) {
        TransactionBuildBlobResponse transactionBuildBlobResponse = new TransactionBuildBlobResponse();
        TransactionBuildBlobResult transactionBuildBlobResult = new TransactionBuildBlobResult();
        try {
            Object[] baseOperations;
            if (Tools.isEmpty(transactionBuildBlobRequest).booleanValue()) {
                throw new SDKException(SdkError.REQUEST_NULL_ERROR);
            }
            String sourceAddress = transactionBuildBlobRequest.getSourceAddress();
            if (!PublicKey.isAddressValid((String)sourceAddress)) {
                throw new SDKException(SdkError.INVALID_SOURCEADDRESS_ERROR);
            }
            Long nonce = transactionBuildBlobRequest.getNonce();
            if (Tools.isEmpty(nonce).booleanValue() || nonce < 1L) {
                throw new SDKException(SdkError.INVALID_NONCE_ERROR);
            }
            Long gasPrice = transactionBuildBlobRequest.getGasPrice();
            if (Tools.isEmpty(gasPrice).booleanValue() || gasPrice < 0L) {
                throw new SDKException(SdkError.INVALID_GASPRICE_ERROR);
            }
            Long feeLimit = transactionBuildBlobRequest.getFeeLimit();
            if (Tools.isEmpty(feeLimit).booleanValue() || feeLimit < 0L) {
                throw new SDKException(SdkError.INVALID_FEELIMIT_ERROR);
            }
            Long ceilLedgerSeq = transactionBuildBlobRequest.getCeilLedgerSeq();
            if (!Tools.isEmpty(ceilLedgerSeq).booleanValue() && ceilLedgerSeq < 0L) {
                throw new SDKException(SdkError.INVALID_CEILLEDGERSEQ_ERROR);
            }
            String metadata = transactionBuildBlobRequest.getMetadata();
            Chain.Transaction.Builder transaction = Chain.Transaction.newBuilder();
            if (!Tools.isEmpty(metadata).booleanValue()) {
                transaction.setMetadata(ByteString.copyFromUtf8((String)metadata));
            }
            if (Tools.isEmpty(baseOperations = transactionBuildBlobRequest.getOperations()).booleanValue()) {
                throw new SDKException(SdkError.OPERATIONS_EMPTY_ERROR);
            }
            this.buildOperations((BaseOperation[])baseOperations, sourceAddress, transaction);
            transaction.setSourceAddress(sourceAddress);
            transaction.setNonce(nonce);
            transaction.setFeeLimit(feeLimit);
            transaction.setGasPrice(gasPrice);
            if (!Tools.isEmpty(SDK.getSdk().getChainId()).booleanValue()) {
                transaction.setChainId(SDK.getSdk().getChainId());
            }
            if (!Tools.isEmpty(ceilLedgerSeq).booleanValue()) {
                BlockServiceImpl blockService = new BlockServiceImpl();
                BlockGetNumberResponse blockGetNumberResponse = blockService.getNumber();
                Integer errorCode = blockGetNumberResponse.getErrorCode();
                if (!Tools.isEmpty(errorCode).booleanValue() && errorCode != 0) {
                    String errorDesc = blockGetNumberResponse.getErrorDesc();
                    throw new SDKException(errorCode, errorDesc);
                }
                if (Tools.isEmpty(errorCode).booleanValue()) {
                    throw new SDKException(SdkError.CONNECTNETWORK_ERROR);
                }
                Long blockNumber = blockGetNumberResponse.getResult().getHeader().getBlockNumber();
                transaction.setCeilLedgerSeq(ceilLedgerSeq + blockNumber);
            }
            byte[] transactionBlobBytes = transaction.build().toByteArray();
            String transactionBlob = HexFormat.byteToHex((byte[])transactionBlobBytes);
            transactionBuildBlobResult.setTransactionBlob(transactionBlob);
            transactionBuildBlobResult.setHash(HashUtil.GenerateHashHex((byte[])transactionBlobBytes));
            transactionBuildBlobResponse.buildResponse(SdkError.SUCCESS, transactionBuildBlobResult);
        }
        catch (SDKException apiException) {
            Integer errorCode = apiException.getErrorCode();
            String errorDesc = apiException.getErrorDesc();
            transactionBuildBlobResponse.buildResponse(errorCode, errorDesc, transactionBuildBlobResult);
        }
        catch (Exception e) {
            transactionBuildBlobResponse.buildResponse(SdkError.SYSTEM_ERROR.getCode(), e.getMessage(), transactionBuildBlobResult);
        }
        return transactionBuildBlobResponse;
    }

    @Override
    public TransactionParseBlobResponse parseBlob(TransactionParseBlobRequest transactionParseBlobRequest) {
        TransactionParseBlobResponse transactionParseBlobResponse = new TransactionParseBlobResponse();
        TransactionParseBlobResult transactionParseBlobResult = new TransactionParseBlobResult();
        try {
            if (Tools.isEmpty(transactionParseBlobRequest).booleanValue()) {
                throw new SDKException(SdkError.REQUEST_NULL_ERROR);
            }
            String blob = transactionParseBlobRequest.getBlob();
            if (Tools.isEmpty(blob).booleanValue()) {
                throw new SDKException(SdkError.INVALID_BLOB_ERROR);
            }
            Chain.Transaction transaction = Chain.Transaction.parseFrom(HexFormat.hexToByte((String)blob));
            JsonFormat jsonFormat = new JsonFormat();
            String transactionJson = jsonFormat.printToString((Message)transaction);
            transactionParseBlobResult = (TransactionParseBlobResult)JSONObject.parseObject((String)transactionJson, TransactionParseBlobResult.class);
            transactionParseBlobResponse.buildResponse(SdkError.SUCCESS, transactionParseBlobResult);
        }
        catch (SDKException sdkException) {
            Integer errorCode = sdkException.getErrorCode();
            String errorDesc = sdkException.getErrorDesc();
            transactionParseBlobResponse.buildResponse(errorCode, errorDesc, transactionParseBlobResult);
        }
        catch (InvalidProtocolBufferException e) {
            transactionParseBlobResponse.buildResponse(SdkError.INVALID_BLOB_ERROR, transactionParseBlobResult);
        }
        catch (Exception e) {
            transactionParseBlobResponse.buildResponse(SdkError.SYSTEM_ERROR.getCode(), e.getMessage(), transactionParseBlobResult);
        }
        return transactionParseBlobResponse;
    }

    @Override
    public TransactionEvaluateFeeResponse evaluateFee(TransactionEvaluateFeeRequest transactionEvaluateFeeRequest) {
        TransactionEvaluateFeeResponse transactionEvaluateFeeResponse = new TransactionEvaluateFeeResponse();
        TransactionEvaluateFeeResult transactionEvaluateFeeResult = new TransactionEvaluateFeeResult();
        try {
            if (Tools.isEmpty(General.getInstance().getUrl()).booleanValue()) {
                throw new SDKException(SdkError.URL_EMPTY_ERROR);
            }
            if (Tools.isEmpty(transactionEvaluateFeeRequest).booleanValue()) {
                throw new SDKException(SdkError.REQUEST_NULL_ERROR);
            }
            String sourceAddress = transactionEvaluateFeeRequest.getSourceAddress();
            if (!PublicKey.isAddressValid((String)sourceAddress)) {
                throw new SDKException(SdkError.INVALID_SOURCEADDRESS_ERROR);
            }
            Long nonce = transactionEvaluateFeeRequest.getNonce();
            if (Tools.isEmpty(nonce).booleanValue() || nonce < 1L) {
                throw new SDKException(SdkError.INVALID_NONCE_ERROR);
            }
            Integer signatureNum = transactionEvaluateFeeRequest.getSignatureNumber();
            if (Tools.isEmpty(signatureNum).booleanValue() || signatureNum < 1) {
                throw new SDKException(SdkError.INVALID_SIGNATURENUMBER_ERROR);
            }
            Long ceilLedgerSeq = transactionEvaluateFeeRequest.getCeilLedgerSeq();
            if (!Tools.isEmpty(ceilLedgerSeq).booleanValue() && ceilLedgerSeq < 0L) {
                throw new SDKException(SdkError.INVALID_CEILLEDGERSEQ_ERROR);
            }
            String metadata = transactionEvaluateFeeRequest.getMetadata();
            Chain.Transaction.Builder transaction = Chain.Transaction.newBuilder();
            Object[] baseOperations = transactionEvaluateFeeRequest.getOperations();
            if (Tools.isEmpty(baseOperations).booleanValue()) {
                throw new SDKException(SdkError.OPERATIONS_EMPTY_ERROR);
            }
            this.buildOperations((BaseOperation[])baseOperations, sourceAddress, transaction);
            transaction.setSourceAddress(sourceAddress);
            transaction.setNonce(nonce);
            if (!Tools.isEmpty(metadata).booleanValue()) {
                transaction.setMetadata(ByteString.copyFromUtf8((String)metadata));
            }
            if (!Tools.isEmpty(ceilLedgerSeq).booleanValue()) {
                transaction.setCeilLedgerSeq(ceilLedgerSeq);
            }
            JsonFormat jsonFormat = new JsonFormat();
            String transactionStr = jsonFormat.printToString((Message)transaction.build());
            JSONObject transactionJson = JSONObject.parseObject((String)transactionStr);
            JSONObject testTransactionRequest = new JSONObject();
            JSONArray transactionItems = new JSONArray();
            JSONObject transactionItem = new JSONObject();
            transactionItem.put("transaction_json", (Object)transactionJson);
            transactionItems.add((Object)transactionItem);
            testTransactionRequest.put("items", (Object)transactionItems);
            String evaluationFeeUrl = General.getInstance().transactionEvaluationFee();
            String result = HttpKit.post(evaluationFeeUrl, testTransactionRequest.toJSONString());
            transactionEvaluateFeeResponse = (TransactionEvaluateFeeResponse)JSON.parseObject((String)result, TransactionEvaluateFeeResponse.class);
        }
        catch (SDKException apiException) {
            Integer errorCode = apiException.getErrorCode();
            String errorDesc = apiException.getErrorDesc();
            transactionEvaluateFeeResponse.buildResponse(errorCode, errorDesc, transactionEvaluateFeeResult);
        }
        catch (IOException | KeyManagementException | NoSuchAlgorithmException | NoSuchProviderException e) {
            transactionEvaluateFeeResponse.buildResponse(SdkError.CONNECTNETWORK_ERROR, transactionEvaluateFeeResult);
        }
        catch (Exception e) {
            transactionEvaluateFeeResponse.buildResponse(SdkError.SYSTEM_ERROR.getCode(), e.getMessage(), transactionEvaluateFeeResult);
        }
        return transactionEvaluateFeeResponse;
    }

    @Override
    public TransactionSignResponse sign(TransactionSignRequest transactionSignRequest) {
        TransactionSignResponse transactionSignResponse = new TransactionSignResponse();
        TransactionSignResult transactionSignResult = new TransactionSignResult();
        try {
            if (Tools.isEmpty(transactionSignRequest).booleanValue()) {
                throw new SDKException(SdkError.REQUEST_NULL_ERROR);
            }
            String blob = transactionSignRequest.getBlob();
            if (Tools.isEmpty(blob).booleanValue()) {
                throw new SDKException(SdkError.INVALID_BLOB_ERROR);
            }
            byte[] blobBytes = HexFormat.hexToByte((String)blob);
            Chain.Transaction.parseFrom(blobBytes);
            Object[] privateKeys = transactionSignRequest.getPrivateKeys();
            if (Tools.isEmpty(privateKeys).booleanValue()) {
                throw new SDKException(SdkError.PRIVATEKEY_NULL_ERROR);
            }
            int length = privateKeys.length;
            Signature[] signatures = new Signature[length];
            for (int i = 0; i < length; ++i) {
                if (!PrivateKey.isPrivateKeyValid((String)privateKeys[i])) {
                    throw new SDKException(SdkError.PRIVATEKEY_ONE_ERROR);
                }
                Signature signature = new Signature();
                byte[] signBytes = PrivateKey.sign((byte[])blobBytes, (String)privateKeys[i]);
                String publicKey = PrivateKey.getEncPublicKey((String)privateKeys[i]);
                signature.setSignData(HexFormat.byteToHex((byte[])signBytes));
                signature.setPublicKey(publicKey);
                signatures[i] = signature;
            }
            transactionSignResult.setSignatures(signatures);
            transactionSignResponse.buildResponse(SdkError.SUCCESS, transactionSignResult);
        }
        catch (SDKException apiException) {
            Integer errorCode = apiException.getErrorCode();
            String errorDesc = apiException.getErrorDesc();
            transactionSignResponse.buildResponse(errorCode, errorDesc, transactionSignResult);
        }
        catch (InvalidProtocolBufferException | IllegalArgumentException e) {
            transactionSignResponse.buildResponse(SdkError.INVALID_BLOB_ERROR, transactionSignResult);
        }
        catch (Exception e) {
            e.printStackTrace();
            transactionSignResponse.buildResponse(SdkError.SYSTEM_ERROR.getCode(), e.getMessage(), transactionSignResult);
        }
        return transactionSignResponse;
    }

    @Override
    public TransactionSubmitResponse submit(TransactionSubmitRequest transactionSubmitRequest) {
        TransactionSubmitResponse transactionSubmitResponse = new TransactionSubmitResponse();
        TransactionSubmitResult transactionSubmitResult = new TransactionSubmitResult();
        try {
            if (Tools.isEmpty(General.getInstance().getUrl()).booleanValue()) {
                throw new SDKException(SdkError.URL_EMPTY_ERROR);
            }
            if (Tools.isEmpty(transactionSubmitRequest).booleanValue()) {
                throw new SDKException(SdkError.REQUEST_NULL_ERROR);
            }
            String blob = transactionSubmitRequest.getTransactionBlob();
            if (Tools.isEmpty(blob).booleanValue()) {
                throw new SDKException(SdkError.INVALID_BLOB_ERROR);
            }
            Chain.Transaction.parseFrom(HexFormat.hexToByte((String)blob));
            JSONObject transactionItemsRequest = new JSONObject();
            JSONArray transactionItems = new JSONArray();
            JSONObject transactionItem = new JSONObject();
            transactionItem.put("transaction_blob", (Object)blob);
            JSONArray signatureItems = new JSONArray();
            Object[] signatures = transactionSubmitRequest.getSignatures();
            if (Tools.isEmpty(signatures).booleanValue()) {
                throw new SDKException(SdkError.SIGNATURE_EMPTY_ERROR);
            }
            int length = signatures.length;
            for (int i = 0; i < length; ++i) {
                JSONObject signatureItem = new JSONObject();
                Object signature = signatures[i];
                String signData = ((Signature)signature).getSignData();
                if (Tools.isEmpty(signData).booleanValue()) {
                    throw new SDKException(SdkError.SIGNDATA_NULL_ERROR);
                }
                String publicKey = ((Signature)signature).getPublicKey();
                if (Tools.isEmpty(publicKey).booleanValue()) {
                    throw new SDKException(SdkError.PUBLICKEY_NULL_ERROR);
                }
                signatureItem.put("sign_data", (Object)signData);
                signatureItem.put("public_key", (Object)publicKey);
                signatureItems.add((Object)signatureItem);
            }
            transactionItem.put("signatures", (Object)signatureItems);
            transactionItems.add((Object)transactionItem);
            transactionItemsRequest.put("items", (Object)transactionItems);
            String submitUrl = General.getInstance().transactionSubmitUrl();
            String transactionRequest = transactionItemsRequest.toJSONString();
            String result = HttpKit.post(submitUrl, transactionRequest);
            TransactionSubmitHttpResponse transactionSubmitHttpResponse = (TransactionSubmitHttpResponse)JSONObject.parseObject((String)result, TransactionSubmitHttpResponse.class);
            Integer successCount = transactionSubmitHttpResponse.getSuccessCount();
            Object[] httpResults = transactionSubmitHttpResponse.getResults();
            if (!Tools.isEmpty(httpResults).booleanValue()) {
                transactionSubmitResult.setHash(((TransactionSubmitHttpResult)httpResults[0]).getHash());
                if (!Tools.isEmpty(successCount).booleanValue() && 0 == successCount) {
                    Integer errorCode = ((TransactionSubmitHttpResult)httpResults[0]).getErrorCode();
                    String errorDesc = ((TransactionSubmitHttpResult)httpResults[0]).getErrorDesc();
                    throw new SDKException(errorCode, errorDesc);
                }
            } else {
                throw new SDKException(SdkError.INVALID_BLOB_ERROR);
            }
            transactionSubmitResponse.buildResponse(SdkError.SUCCESS, transactionSubmitResult);
        }
        catch (SDKException apiException) {
            Integer errorCode = apiException.getErrorCode();
            String errorDesc = apiException.getErrorDesc();
            transactionSubmitResponse.buildResponse(errorCode, errorDesc, transactionSubmitResult);
        }
        catch (InvalidProtocolBufferException | IllegalArgumentException e) {
            transactionSubmitResponse.buildResponse(SdkError.INVALID_BLOB_ERROR, transactionSubmitResult);
        }
        catch (IOException | KeyManagementException | NoSuchAlgorithmException | NoSuchProviderException e) {
            transactionSubmitResponse.buildResponse(SdkError.CONNECTN_BLOCKCHAIN_ERROR, transactionSubmitResult);
        }
        catch (Exception e) {
            transactionSubmitResponse.buildResponse(SdkError.SYSTEM_ERROR.getCode(), e.getMessage(), transactionSubmitResult);
        }
        return transactionSubmitResponse;
    }

    @Override
    public TransactionGetInfoResponse getInfo(TransactionGetInfoRequest transactionGetInfoRequest) {
        TransactionGetInfoResponse transactionGetInfoResponse = new TransactionGetInfoResponse();
        TransactionGetInfoResult transactionGetInfoResult = new TransactionGetInfoResult();
        try {
            if (Tools.isEmpty(General.getInstance().getUrl()).booleanValue()) {
                throw new SDKException(SdkError.URL_EMPTY_ERROR);
            }
            if (Tools.isEmpty(transactionGetInfoRequest).booleanValue()) {
                throw new SDKException(SdkError.REQUEST_NULL_ERROR);
            }
            String hash = transactionGetInfoRequest.getHash();
            if (Tools.isEmpty(hash).booleanValue() || hash.length() != Constant.HASH_HEX_LENGTH.intValue()) {
                throw new SDKException(SdkError.INVALID_HASH_ERROR);
            }
            transactionGetInfoResponse = TransactionServiceImpl.getTransactionInfo(hash);
        }
        catch (SDKException apiException) {
            Integer errorCode = apiException.getErrorCode();
            String errorDesc = apiException.getErrorDesc();
            transactionGetInfoResponse.buildResponse(errorCode, errorDesc, transactionGetInfoResult);
        }
        catch (IOException | KeyManagementException | NoSuchAlgorithmException | NoSuchProviderException e) {
            transactionGetInfoResponse.buildResponse(SdkError.CONNECTNETWORK_ERROR, transactionGetInfoResult);
        }
        catch (Exception e) {
            transactionGetInfoResponse.buildResponse(SdkError.SYSTEM_ERROR.getCode(), e.getMessage(), transactionGetInfoResult);
        }
        return transactionGetInfoResponse;
    }

    private void buildOperations(BaseOperation[] operationBase, String transSourceAddress, Chain.Transaction.Builder transaction) throws SDKException {
        for (int i = 0; i < operationBase.length; ++i) {
            Chain.Operation operation;
            OperationType operationType = operationBase[i].getOperationType();
            switch (operationType) {
                case ACCOUNT_ACTIVATE: {
                    operation = AccountServiceImpl.activate((AccountActivateOperation)operationBase[i], transSourceAddress);
                    break;
                }
                case ACCOUNT_SET_METADATA: {
                    operation = AccountServiceImpl.setMetadata((AccountSetMetadataOperation)operationBase[i]);
                    break;
                }
                case ACCOUNT_SET_PRIVILEGE: {
                    operation = AccountServiceImpl.setPrivilege((AccountSetPrivilegeOperation)operationBase[i]);
                    break;
                }
                case ASSET_ISSUE: {
                    operation = AssetServiceImpl.issue((AssetIssueOperation)operationBase[i]);
                    break;
                }
                case ASSET_SEND: {
                    operation = AssetServiceImpl.send((AssetSendOperation)operationBase[i], transSourceAddress);
                    break;
                }
                case GAS_SEND: {
                    operation = GasServiceImpl.send((GasSendOperation)operationBase[i], transSourceAddress);
                    break;
                }
                case CONTRACT_CREATE: {
                    operation = ContractServiceImpl.create((ContractCreateOperation)operationBase[i]);
                    break;
                }
                case CONTRACT_INVOKE_BY_ASSET: {
                    operation = ContractServiceImpl.invokeByAsset((ContractInvokeByAssetOperation)operationBase[i], transSourceAddress);
                    break;
                }
                case CONTRACT_INVOKE_BY_GAS: {
                    operation = ContractServiceImpl.invokeByGas((ContractInvokeByGasOperation)operationBase[i], transSourceAddress);
                    break;
                }
                case LOG_CREATE: {
                    operation = LogServiceImpl.create((LogCreateOperation)operationBase[i]);
                    break;
                }
                default: {
                    throw new SDKException(SdkError.OPERATIONS_ONE_ERROR);
                }
            }
            if (Tools.isEmpty(operation).booleanValue()) {
                throw new SDKException(SdkError.OPERATIONS_ONE_ERROR);
            }
            transaction.addOperations(operation);
        }
    }

    public static TransactionGetInfoResponse getTransactionInfo(String hash) throws IOException, KeyManagementException, NoSuchAlgorithmException, NoSuchProviderException {
        if (Tools.isEmpty(General.getInstance().getUrl()).booleanValue()) {
            throw new SDKException(SdkError.URL_EMPTY_ERROR);
        }
        String getInfoUrl = General.getInstance().transactionGetInfoUrl(hash);
        String result = HttpKit.get(getInfoUrl);
        return (TransactionGetInfoResponse)JSONObject.parseObject((String)result, TransactionGetInfoResponse.class);
    }
}

