/*
 * Decompiled with CFR 0.152.
 */
package cn.bubi.common;

import cn.bubi.SDK;
import cn.bubi.common.Tools;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class General {
    private static General general = null;
    private String url;

    private General() {
    }

    public static synchronized General getInstance() {
        if (general == null) {
            general = new General();
        }
        General.general.url = SDK.getSdk().getUrl();
        return general;
    }

    public String getUrl() {
        return this.url;
    }

    public String accountGetInfoUrl(String address) throws UnsupportedEncodingException {
        return this.url + "/getAccountBase?address=" + URLEncoder.encode(address, "utf8");
    }

    public String accountGetAssetsUrl(String address) {
        return this.url + "/getAccount?address=" + address;
    }

    public String accountGetMetadataUrl(String address, String key) throws UnsupportedEncodingException {
        return this.url + "/getAccount?address=" + URLEncoder.encode(address, "utf8") + (Tools.isEmpty(key) != false ? "" : "&key=" + URLEncoder.encode(key, "utf8"));
    }

    public String assetGetUrl(String address, String code, String issuer) throws UnsupportedEncodingException {
        return this.url + "/getAccount?address=" + URLEncoder.encode(address, "utf8") + "&code=" + URLEncoder.encode(code, "utf8") + "&issuer=" + URLEncoder.encode(issuer, "utf8");
    }

    public String contractCallUrl() {
        return this.url + "/callContract";
    }

    public String transactionEvaluationFee() {
        return this.url + "/testTransaction";
    }

    public String transactionSubmitUrl() {
        return this.url + "/submitTransaction";
    }

    public String transactionGetInfoUrl(String hash) throws UnsupportedEncodingException {
        return this.url + "/getTransactionHistory?hash=" + URLEncoder.encode(hash, "utf8");
    }

    public String blockGetNumberUrl() {
        return this.url + "/getLedger";
    }

    public String blockCheckStatusUrl() {
        return this.url + "/getModulesStatus";
    }

    public String blockGetTransactionsUrl(Long blockNumber) {
        return this.url + "/getTransactionHistory?ledger_seq=" + blockNumber;
    }

    public String blockGetInfoUrl(Long blockNumber) {
        return this.url + "/getLedger?seq=" + blockNumber;
    }

    public String blockGetLatestInfoUrl() {
        return this.url + "/getLedger";
    }

    public String blockGetValidatorsUrl(Long blockNumber) {
        return this.url + "/getLedger?seq=" + blockNumber + "&with_validator=true";
    }

    public String blockGetLatestValidatorsUrl() {
        return this.url + "/getLedger?with_validator=true";
    }

    public String blockGetRewardUrl(Long blockNumber) {
        return this.url + "/getLedger?seq=" + blockNumber + "&with_block_reward=true";
    }

    public String blockGetLatestRewardUrl() {
        return this.url + "/getLedger?with_block_reward=true";
    }

    public String blockGetFeesUrl(Long blockNumber) {
        return this.url + "/getLedger?seq=" + blockNumber + "&with_fee=true";
    }

    public String blockGetLatestFeeUrl() {
        return this.url + "/getLedger?with_fee=true";
    }
}

