/*
 * Decompiled with CFR 0.152.
 */
package cn.bubi.common;

public class ToBaseUnit {
    public static Long ToUGas(String buAmount) {
        return ToBaseUnit.unitWithDecimals(buAmount, 8);
    }

    public static String ToGas(String moAmount) {
        return ToBaseUnit.unitWithoutDecimals(moAmount, 8);
    }

    public static String unitWithoutDecimals(String amountWithDecimals, int decimals) {
        if (decimals > 18 || decimals < 0) {
            return null;
        }
        if (!amountWithDecimals.matches("(^0?$)|(^[1-9][0-9]{0,18}?$)")) {
            return null;
        }
        String longMaxValue = String.valueOf(Long.MAX_VALUE);
        if (amountWithDecimals.compareTo(longMaxValue) > 0 && amountWithDecimals.length() == longMaxValue.length() || amountWithDecimals.length() > longMaxValue.length()) {
            return null;
        }
        String afterStr = "";
        String beforeStr = "";
        if (amountWithDecimals.length() > decimals) {
            afterStr = "." + amountWithDecimals.substring(amountWithDecimals.length() - decimals);
            beforeStr = amountWithDecimals.substring(0, amountWithDecimals.length() - decimals);
        } else {
            String addZero = "";
            for (int i = 0; i < decimals - amountWithDecimals.length(); ++i) {
                addZero = addZero + "0";
            }
            afterStr = "0." + addZero + amountWithDecimals;
        }
        String result = ToBaseUnit.delEndsZero(beforeStr + afterStr);
        if (result.endsWith(".")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public static Long unitWithDecimals(String amountWithoutDecimals, int decimals) {
        if (decimals > 18 || decimals < 0) {
            return null;
        }
        if (!amountWithoutDecimals.matches("(^0(\\.[0-9]{0," + (decimals - 1) + "}[1-9])?$)|" + "(^[1-9][0-9]{0," + (18 - decimals) + "}(\\.[0-9]{0," + (decimals - 1) + "}[1-9])?$)")) {
            return null;
        }
        String longMaxValue = String.valueOf(Long.MAX_VALUE);
        String beforeStr = "";
        String afterStr = "";
        String[] tempArray = amountWithoutDecimals.split("\\.");
        if (tempArray.length <= 1) {
            long temp = (long)Math.pow(10.0, decimals);
            String zeroNumber = Long.toString(temp);
            String amount = amountWithoutDecimals + zeroNumber.substring(1);
            if (amount.compareTo(longMaxValue) > 0) {
                return null;
            }
            return Long.parseLong(amount);
        }
        beforeStr = tempArray[0];
        afterStr = tempArray[1];
        int endIndex = afterStr.length();
        if (afterStr.length() > decimals) {
            endIndex = decimals;
            afterStr = afterStr.substring(0, endIndex);
        } else {
            String addZero = "";
            for (int i = 0; i < decimals - afterStr.length(); ++i) {
                addZero = addZero + "0";
            }
            afterStr = afterStr + addZero;
        }
        String amount = ToBaseUnit.delStartZero(beforeStr + afterStr);
        if (amount.compareTo(longMaxValue) > 0 && amount.length() == longMaxValue.length() || amount.length() > longMaxValue.length()) {
            return null;
        }
        return Long.parseLong(amount);
    }

    public static void main(String[] args) {
        Long s1 = ToBaseUnit.ToUGas("99999999999");
        System.out.println(s1);
    }

    public static String delEndsZero(String src) {
        if (src.endsWith("0")) {
            return ToBaseUnit.delEndsZero(src.substring(0, src.length() - 1));
        }
        return src;
    }

    public static String delStartZero(String src) {
        if (src.startsWith("0")) {
            return ToBaseUnit.delStartZero(src.substring(1, src.length()));
        }
        return src;
    }
}

