/*
 * Decompiled with CFR 0.152.
 */
package cn.bubi.contract.impl;

import cn.bubi.blockchain.impl.TransactionServiceImpl;
import cn.bubi.common.Constant;
import cn.bubi.common.General;
import cn.bubi.common.Tools;
import cn.bubi.contract.ContractService;
import cn.bubi.crypto.http.HttpKit;
import cn.bubi.crypto.protobuf.Chain;
import cn.bubi.encryption.key.PublicKey;
import cn.bubi.exception.SDKException;
import cn.bubi.exception.SdkError;
import cn.bubi.model.request.ContractCallRequest;
import cn.bubi.model.request.ContractCheckValidRequest;
import cn.bubi.model.request.ContractGetAddressRequest;
import cn.bubi.model.request.ContractGetInfoRequest;
import cn.bubi.model.request.operation.ContractCreateOperation;
import cn.bubi.model.request.operation.ContractInvokeByAssetOperation;
import cn.bubi.model.request.operation.ContractInvokeByGasOperation;
import cn.bubi.model.response.ContractCallResponse;
import cn.bubi.model.response.ContractCheckValidResponse;
import cn.bubi.model.response.ContractGetAddressResponse;
import cn.bubi.model.response.ContractGetInfoResponse;
import cn.bubi.model.response.TransactionGetInfoResponse;
import cn.bubi.model.response.result.ContractCallResult;
import cn.bubi.model.response.result.ContractCheckValidResult;
import cn.bubi.model.response.result.ContractGetAddressResult;
import cn.bubi.model.response.result.ContractGetInfoResult;
import cn.bubi.model.response.result.data.ContractAddressInfo;
import cn.bubi.model.response.result.data.ContractInfo;
import cn.bubi.model.response.result.data.TransactionHistory;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.List;

public class ContractServiceImpl
implements ContractService {
    public static Chain.Operation create(ContractCreateOperation contractCreateOperation) throws SDKException {
        Chain.Operation.Builder operation;
        try {
            String sourceAddress = contractCreateOperation.getSourceAddress();
            if (!Tools.isEmpty(sourceAddress).booleanValue() && !PublicKey.isAddressValid((String)sourceAddress)) {
                throw new SDKException(SdkError.INVALID_SOURCEADDRESS_ERROR);
            }
            Long initBalance = contractCreateOperation.getInitBalance();
            if (Tools.isEmpty(initBalance).booleanValue() || initBalance <= 0L) {
                throw new SDKException(SdkError.INVALID_INITBALANCE_ERROR);
            }
            Integer type = contractCreateOperation.getType();
            if (!Tools.isEmpty(type).booleanValue() && type < 0) {
                throw new SDKException(SdkError.INVALID_CONTRACT_TYPE_ERROR);
            }
            String payload = contractCreateOperation.getPayload();
            if (Tools.isEmpty(payload).booleanValue()) {
                throw new SDKException(SdkError.PAYLOAD_EMPTY_ERROR);
            }
            String metadata = contractCreateOperation.getMetadata();
            String initInput = contractCreateOperation.getInitInput();
            operation = Chain.Operation.newBuilder();
            operation.setType(Chain.Operation.Type.CREATE_ACCOUNT);
            if (!Tools.isEmpty(sourceAddress).booleanValue()) {
                operation.setSourceAddress(sourceAddress);
            }
            if (!Tools.isEmpty(metadata).booleanValue()) {
                operation.setMetadata(ByteString.copyFromUtf8((String)metadata));
            }
            Chain.OperationCreateAccount.Builder operationCreateContract = operation.getCreateAccountBuilder();
            operationCreateContract.setInitBalance(initBalance);
            if (!Tools.isEmpty(initInput).booleanValue()) {
                operationCreateContract.setInitInput(initInput);
            }
            Chain.Contract.Builder contract = operationCreateContract.getContractBuilder();
            if (!Tools.isEmpty(type).booleanValue()) {
                Chain.Contract.ContractType contractType = Chain.Contract.ContractType.forNumber(type);
                if (Tools.isEmpty((Object)contractType).booleanValue()) {
                    throw new SDKException(SdkError.INVALID_CONTRACT_TYPE_ERROR);
                }
                contract.setType(contractType);
            }
            contract.setPayload(payload);
            Chain.AccountPrivilege.Builder accountPrivilege = operationCreateContract.getPrivBuilder();
            accountPrivilege.setMasterWeight(0L);
            Chain.AccountThreshold.Builder accountThreshold = accountPrivilege.getThresholdsBuilder();
            accountThreshold.setTxThreshold(1L);
        }
        catch (SDKException sdkException) {
            throw sdkException;
        }
        catch (Exception e) {
            throw new SDKException(SdkError.SYSTEM_ERROR.getCode(), e.getMessage());
        }
        return operation.build();
    }

    public static Chain.Operation invokeByAsset(ContractInvokeByAssetOperation contractInvokeByAssetOperation, String transSourceAddress) throws SDKException {
        Chain.Operation.Builder operation;
        try {
            String sourceAddress = contractInvokeByAssetOperation.getSourceAddress();
            if (!Tools.isEmpty(sourceAddress).booleanValue() && !PublicKey.isAddressValid((String)sourceAddress)) {
                throw new SDKException(SdkError.INVALID_SOURCEADDRESS_ERROR);
            }
            String contractAddress = contractInvokeByAssetOperation.getContractAddress();
            if (!PublicKey.isAddressValid((String)contractAddress)) {
                throw new SDKException(SdkError.INVALID_CONTRACTADDRESS_ERROR);
            }
            if (!Tools.isEmpty(sourceAddress).booleanValue() && sourceAddress.equals(contractAddress) || transSourceAddress.equals(contractAddress)) {
                throw new SDKException(SdkError.SOURCEADDRESS_EQUAL_CONTRACTADDRESS_ERROR);
            }
            String code = contractInvokeByAssetOperation.getCode();
            if (!(Tools.isNULL(code).booleanValue() || code.length() >= 1 && (long)code.length() <= Constant.ASSET_CODE_MAX)) {
                throw new SDKException(SdkError.INVALID_ASSET_CODE_ERROR);
            }
            String issuer = contractInvokeByAssetOperation.getIssuer();
            if (!Tools.isEmpty(issuer).booleanValue() && !PublicKey.isAddressValid((String)issuer)) {
                throw new SDKException(SdkError.INVALID_ISSUER_ADDRESS_ERROR);
            }
            Long assetAmount = contractInvokeByAssetOperation.getAssetAmount();
            if (!Tools.isEmpty(assetAmount).booleanValue() && assetAmount < 0L) {
                throw new SDKException(SdkError.INVALID_ASSET_AMOUNT_ERROR);
            }
            String metadata = contractInvokeByAssetOperation.getMetadata();
            if (!ContractServiceImpl.checkContractValid(contractAddress)) {
                throw new SDKException(SdkError.CONTRACTADDRESS_NOT_CONTRACTACCOUNT_ERROR);
            }
            String input = contractInvokeByAssetOperation.getInput();
            operation = Chain.Operation.newBuilder();
            operation.setType(Chain.Operation.Type.PAY_ASSET);
            if (!Tools.isEmpty(sourceAddress).booleanValue()) {
                operation.setSourceAddress(sourceAddress);
            }
            if (!Tools.isEmpty(metadata).booleanValue()) {
                operation.setMetadata(ByteString.copyFromUtf8((String)metadata));
            }
            Chain.OperationPayAsset.Builder operationPayAsset = operation.getPayAssetBuilder();
            operationPayAsset.setDestAddress(contractAddress);
            if (!Tools.isEmpty(input).booleanValue()) {
                operationPayAsset.setInput(input);
            }
            if (code != null && issuer != null && assetAmount != null && assetAmount != 0L) {
                Chain.Asset.Builder asset = operationPayAsset.getAssetBuilder();
                Chain.AssetKey.Builder assetKey = asset.getKeyBuilder();
                assetKey.setCode(code);
                assetKey.setIssuer(issuer);
                asset.setAmount(assetAmount);
            }
        }
        catch (SDKException sdkException) {
            throw sdkException;
        }
        catch (Exception e) {
            throw new SDKException(SdkError.SYSTEM_ERROR.getCode(), e.getMessage());
        }
        return operation.build();
    }

    public static Chain.Operation invokeByGas(ContractInvokeByGasOperation contractInvokeByGasOperation, String transSourceAddress) throws SDKException {
        Chain.Operation.Builder operation;
        try {
            String sourceAddress = contractInvokeByGasOperation.getSourceAddress();
            if (!Tools.isEmpty(sourceAddress).booleanValue() && !PublicKey.isAddressValid((String)sourceAddress)) {
                throw new SDKException(SdkError.INVALID_SOURCEADDRESS_ERROR);
            }
            String contractAddress = contractInvokeByGasOperation.getContractAddress();
            if (!PublicKey.isAddressValid((String)contractAddress)) {
                throw new SDKException(SdkError.INVALID_CONTRACTADDRESS_ERROR);
            }
            if (!Tools.isEmpty(sourceAddress).booleanValue() && sourceAddress.equals(contractAddress) || transSourceAddress.equals(contractAddress)) {
                throw new SDKException(SdkError.SOURCEADDRESS_EQUAL_CONTRACTADDRESS_ERROR);
            }
            Long buAmount = contractInvokeByGasOperation.getBuAmount();
            if (Tools.isEmpty(buAmount).booleanValue() || buAmount < 0L) {
                throw new SDKException(SdkError.INVALID_ASSET_AMOUNT_ERROR);
            }
            String metadata = contractInvokeByGasOperation.getMetadata();
            if (!ContractServiceImpl.checkContractValid(contractAddress)) {
                throw new SDKException(SdkError.CONTRACTADDRESS_NOT_CONTRACTACCOUNT_ERROR);
            }
            String input = contractInvokeByGasOperation.getInput();
            operation = Chain.Operation.newBuilder();
            operation.setType(Chain.Operation.Type.PAY_COIN);
            if (!Tools.isEmpty(sourceAddress).booleanValue()) {
                operation.setSourceAddress(sourceAddress);
            }
            if (!Tools.isEmpty(metadata).booleanValue()) {
                operation.setMetadata(ByteString.copyFromUtf8((String)metadata));
            }
            Chain.OperationPayCoin.Builder operationPayCoin = operation.getPayCoinBuilder();
            operationPayCoin.setDestAddress(contractAddress);
            operationPayCoin.setAmount(buAmount);
            if (!Tools.isEmpty(input).booleanValue()) {
                operationPayCoin.setInput(input);
            }
        }
        catch (SDKException sdkException) {
            throw sdkException;
        }
        catch (Exception e) {
            throw new SDKException(SdkError.SYSTEM_ERROR.getCode(), e.getMessage());
        }
        return operation.build();
    }

    public static ContractCallResponse callContract(String sourceAddress, String contractAddress, Integer optType, String code, String input, Long contractBalance, Long gasPrice, Long feeLimit) throws KeyManagementException, NoSuchAlgorithmException, NoSuchProviderException, IOException {
        if (Tools.isEmpty(General.getInstance().getUrl()).booleanValue()) {
            throw new SDKException(SdkError.URL_EMPTY_ERROR);
        }
        JSONObject params = new JSONObject();
        params.put("opt_type", (Object)optType);
        params.put("fee_limit", (Object)feeLimit);
        if (!Tools.isEmpty(sourceAddress).booleanValue()) {
            params.put("source_address", (Object)sourceAddress);
        }
        if (!Tools.isEmpty(contractAddress).booleanValue()) {
            params.put("contract_address", (Object)contractAddress);
        }
        if (!Tools.isEmpty(code).booleanValue()) {
            params.put("code", (Object)code);
        }
        if (!Tools.isEmpty(input).booleanValue()) {
            params.put("input", (Object)input);
        }
        if (!Tools.isEmpty(contractBalance).booleanValue()) {
            params.put("contract_balance", (Object)contractBalance);
        }
        if (!Tools.isEmpty(gasPrice).booleanValue()) {
            params.put("gas_price", (Object)gasPrice);
        }
        String contractCallUrl = General.getInstance().contractCallUrl();
        String result = HttpKit.post(contractCallUrl, params.toJSONString());
        return (ContractCallResponse)JSONObject.parseObject((String)result, ContractCallResponse.class);
    }

    private static ContractGetInfoResponse getContractInfo(String contractAddress) throws KeyManagementException, NoSuchAlgorithmException, NoSuchProviderException, IOException, SDKException {
        if (Tools.isEmpty(General.getInstance().getUrl()).booleanValue()) {
            throw new SDKException(SdkError.URL_EMPTY_ERROR);
        }
        String contractGetInfoUrl = General.getInstance().accountGetInfoUrl(contractAddress);
        String result = HttpKit.get(contractGetInfoUrl);
        ContractGetInfoResponse contractGetInfoResponse = (ContractGetInfoResponse)JSON.parseObject((String)result, ContractGetInfoResponse.class);
        Integer errorCode = contractGetInfoResponse.getErrorCode();
        String errorDesc = contractGetInfoResponse.getErrorDesc();
        if (!Tools.isEmpty(errorCode).booleanValue() && errorCode == 4) {
            throw new SDKException(errorCode, null == errorDesc ? "contract account (" + contractAddress + ") doest not exist" : errorDesc);
        }
        SdkError.checkErrorCode(contractGetInfoResponse);
        ContractInfo contractInfo = contractGetInfoResponse.getResult().getContract();
        if (Tools.isEmpty(contractInfo).booleanValue()) {
            throw new SDKException(SdkError.CONTRACTADDRESS_NOT_CONTRACTACCOUNT_ERROR);
        }
        String payLoad = contractInfo.getPayload();
        if (Tools.isEmpty(payLoad).booleanValue()) {
            throw new SDKException(SdkError.CONTRACTADDRESS_NOT_CONTRACTACCOUNT_ERROR);
        }
        return contractGetInfoResponse;
    }

    private static boolean checkContractValid(String contractAddress) throws IOException, NoSuchAlgorithmException, NoSuchProviderException, KeyManagementException {
        boolean isValid = false;
        try {
            ContractServiceImpl.getContractInfo(contractAddress);
            isValid = true;
        }
        catch (SDKException sDKException) {
            // empty catch block
        }
        return isValid;
    }

    @Override
    public ContractGetInfoResponse getInfo(ContractGetInfoRequest contractGetInfoRequest) {
        ContractGetInfoResponse contractGetInfoResponse = new ContractGetInfoResponse();
        ContractGetInfoResult contractGetInfoResult = new ContractGetInfoResult();
        try {
            if (Tools.isEmpty(contractGetInfoRequest).booleanValue()) {
                throw new SDKException(SdkError.REQUEST_NULL_ERROR);
            }
            String contractAddress = contractGetInfoRequest.getContractAddress();
            if (!PublicKey.isAddressValid((String)contractAddress)) {
                throw new SDKException(SdkError.INVALID_CONTRACTADDRESS_ERROR);
            }
            contractGetInfoResponse = ContractServiceImpl.getContractInfo(contractAddress);
        }
        catch (SDKException apiException) {
            Integer errorCode = apiException.getErrorCode();
            String errorDesc = apiException.getErrorDesc();
            contractGetInfoResponse.buildResponse(errorCode, errorDesc, contractGetInfoResult);
        }
        catch (IOException | KeyManagementException | NoSuchAlgorithmException | NoSuchProviderException e) {
            contractGetInfoResponse.buildResponse(SdkError.CONNECTNETWORK_ERROR, contractGetInfoResult);
        }
        catch (Exception e) {
            contractGetInfoResponse.buildResponse(SdkError.SYSTEM_ERROR.getCode(), e.getMessage(), contractGetInfoResult);
        }
        return contractGetInfoResponse;
    }

    @Override
    public ContractCheckValidResponse checkValid(ContractCheckValidRequest contractCheckValidRequest) {
        ContractCheckValidResponse contractCheckValidResponse = new ContractCheckValidResponse();
        ContractCheckValidResult contractCheckValidResult = new ContractCheckValidResult();
        try {
            if (Tools.isEmpty(contractCheckValidRequest).booleanValue()) {
                throw new SDKException(SdkError.REQUEST_NULL_ERROR);
            }
            String contractAddress = contractCheckValidRequest.getContractAddress();
            if (!PublicKey.isAddressValid((String)contractAddress)) {
                throw new SDKException(SdkError.INVALID_CONTRACTADDRESS_ERROR);
            }
            boolean isValid = ContractServiceImpl.checkContractValid(contractAddress);
            contractCheckValidResult.setValid(isValid);
            contractCheckValidResponse.buildResponse(SdkError.SUCCESS, contractCheckValidResult);
        }
        catch (SDKException apiException) {
            Integer errorCode = apiException.getErrorCode();
            String errorDesc = apiException.getErrorDesc();
            contractCheckValidResponse.buildResponse(errorCode, errorDesc, contractCheckValidResult);
        }
        catch (Exception e) {
            contractCheckValidResponse.buildResponse(SdkError.SYSTEM_ERROR.getCode(), e.getMessage(), contractCheckValidResult);
        }
        return contractCheckValidResponse;
    }

    @Override
    public ContractCallResponse call(ContractCallRequest contractCallRequest) {
        ContractCallResponse contractCallResponse = new ContractCallResponse();
        ContractCallResult contractCallResult = new ContractCallResult();
        try {
            if (Tools.isEmpty(contractCallRequest).booleanValue()) {
                throw new SDKException(SdkError.REQUEST_NULL_ERROR);
            }
            String sourceAddress = contractCallRequest.getSourceAddress();
            if (!(Tools.isEmpty(sourceAddress).booleanValue() || sourceAddress.isEmpty() || PublicKey.isAddressValid((String)sourceAddress))) {
                throw new SDKException(SdkError.INVALID_SOURCEADDRESS_ERROR);
            }
            String contractAddress = contractCallRequest.getContractAddress();
            if (!(Tools.isNULL(contractAddress).booleanValue() || contractAddress.isEmpty() || PublicKey.isAddressValid((String)contractAddress))) {
                throw new SDKException(SdkError.INVALID_CONTRACTADDRESS_ERROR);
            }
            if (!Tools.isEmpty(sourceAddress).booleanValue() && !Tools.isNULL(contractAddress).booleanValue() && sourceAddress.equals(contractAddress)) {
                throw new SDKException(SdkError.SOURCEADDRESS_EQUAL_CONTRACTADDRESS_ERROR);
            }
            String code = contractCallRequest.getCode();
            if (Tools.isEmpty(contractAddress).booleanValue() && Tools.isEmpty(code).booleanValue()) {
                throw new SDKException(SdkError.CONTRACTADDRESS_CODE_BOTH_NULL_ERROR);
            }
            Long feeLimit = contractCallRequest.getFeeLimit();
            if (Tools.isEmpty(feeLimit).booleanValue() || feeLimit < 0L) {
                throw new SDKException(SdkError.INVALID_FEELIMIT_ERROR);
            }
            Integer optType = contractCallRequest.getOptType();
            if (Tools.isEmpty(optType).booleanValue() || optType < Constant.OPT_TYPE_MIN || optType > Constant.OPT_TYPE_MAX) {
                throw new SDKException(SdkError.INVALID_OPTTYPE_ERROR);
            }
            String input = contractCallRequest.getInput();
            Long contractBalance = contractCallRequest.getContractBalance();
            Long gasPrice = contractCallRequest.getGasPrice();
            contractCallResponse = ContractServiceImpl.callContract(sourceAddress, contractAddress, optType, code, input, contractBalance, gasPrice, feeLimit);
        }
        catch (SDKException sdkException) {
            Integer errorCode = sdkException.getErrorCode();
            String errorDesc = sdkException.getErrorDesc();
            contractCallResponse.buildResponse(errorCode, errorDesc, contractCallResult);
        }
        catch (IOException | KeyManagementException | NoSuchAlgorithmException | NoSuchProviderException e) {
            contractCallResponse.buildResponse(SdkError.CONNECTNETWORK_ERROR, contractCallResult);
        }
        catch (Exception e) {
            contractCallResponse.buildResponse(SdkError.SYSTEM_ERROR.getCode(), e.getMessage(), contractCallResult);
        }
        return contractCallResponse;
    }

    @Override
    public ContractGetAddressResponse getAddress(ContractGetAddressRequest contractGetAddressRequest) {
        ContractGetAddressResponse contractGetAddressResponse = new ContractGetAddressResponse();
        ContractGetAddressResult contractGetAddressResult = new ContractGetAddressResult();
        try {
            if (Tools.isEmpty(contractGetAddressRequest).booleanValue()) {
                throw new SDKException(SdkError.REQUEST_NULL_ERROR);
            }
            String hash = contractGetAddressRequest.getHash();
            if (Tools.isEmpty(hash).booleanValue() || hash.length() != Constant.HASH_HEX_LENGTH.intValue()) {
                throw new SDKException(SdkError.INVALID_HASH_ERROR);
            }
            TransactionGetInfoResponse transactionGetInfoResponse = TransactionServiceImpl.getTransactionInfo(hash);
            SdkError.checkErrorCode(transactionGetInfoResponse);
            TransactionHistory transactionHistory = transactionGetInfoResponse.getResult().getTransactions()[0];
            if (Tools.isEmpty(transactionHistory).booleanValue()) {
                throw new SDKException(SdkError.INVALID_CONTRACT_HASH_ERROR);
            }
            SdkError.checkErrorCode(transactionHistory.getErrorCode(), transactionHistory.getErrorDesc());
            String contractAddress = transactionHistory.getErrorDesc();
            if (Tools.isEmpty(contractAddress).booleanValue()) {
                throw new SDKException(SdkError.INVALID_CONTRACT_HASH_ERROR);
            }
            List contractAddressInfos = JSONArray.parseArray((String)contractAddress, ContractAddressInfo.class);
            if (Tools.isEmpty((Object)contractAddressInfos).booleanValue()) {
                throw new SDKException(SdkError.INVALID_CONTRACT_HASH_ERROR);
            }
            contractGetAddressResult.setContractAddressInfos(contractAddressInfos);
            contractGetAddressResponse.buildResponse(SdkError.SUCCESS, contractGetAddressResult);
        }
        catch (SDKException apiException) {
            Integer errorCode = apiException.getErrorCode();
            String errorDesc = apiException.getErrorDesc();
            contractGetAddressResponse.buildResponse(errorCode, errorDesc, contractGetAddressResult);
        }
        catch (IOException | KeyManagementException | NoSuchAlgorithmException | NoSuchProviderException e) {
            contractGetAddressResponse.buildResponse(SdkError.CONNECTNETWORK_ERROR, contractGetAddressResult);
        }
        catch (Exception e) {
            contractGetAddressResponse.buildResponse(SdkError.SYSTEM_ERROR.getCode(), e.getMessage(), contractGetAddressResult);
        }
        return contractGetAddressResponse;
    }
}

