/*
 * Decompiled with CFR 0.152.
 */
package cn.bubi.crypto.websocket;

import cn.bubi.crypto.protobuf.Common;
import cn.bubi.crypto.websocket.BlockChainAdapterProc;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.java_websocket.WebSocket;
import org.java_websocket.WebSocketImpl;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_17;
import org.java_websocket.handshake.ServerHandshake;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockChainAdapter {
    private final String adapter_version_ = "2.0.0.0.2221";
    private Map<Integer, BlockChainManager> blockchain_managers_ = new ConcurrentHashMap<Integer, BlockChainManager>();
    private Logger logger_ = LoggerFactory.getLogger(BlockChainAdapter.class);
    private BlockChainAdapterProc[] request_handler_ = new BlockChainAdapterProc[256];
    private BlockChainAdapterProc[] response_handler_ = new BlockChainAdapterProc[256];
    private final long connection_timeout_ = 60000L;
    private final long check_interval = 15000L;
    private final int OVERLAY_PING = 1;

    public BlockChainAdapter(String uri_address) {
        String[] uri_addresses = uri_address.split(";");
        Integer i = 0;
        while (i < uri_addresses.length) {
            BlockChainManager blockchain_manager = new BlockChainManager(i, uri_addresses[i]);
            this.blockchain_managers_.put(i, blockchain_manager);
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
    }

    public void Stop() {
        for (int i = 0; i < this.blockchain_managers_.size(); ++i) {
            this.blockchain_managers_.get(i).Stop();
            this.blockchain_managers_.get(i).Join();
        }
    }

    public boolean IsConnected() {
        boolean is_connect = false;
        for (int i = 0; i < this.blockchain_managers_.size(); ++i) {
            if (!this.blockchain_managers_.get(i).IsConnected()) continue;
            is_connect = true;
            break;
        }
        return is_connect;
    }

    public void AddChainMethod(int type, BlockChainAdapterProc chainMethodProc) {
        this.request_handler_[type] = chainMethodProc;
    }

    public void AddChainResponseMethod(int type, BlockChainAdapterProc chainRequestMethodProc) {
        this.response_handler_[type] = chainRequestMethodProc;
    }

    public boolean Send(int type, byte[] msg) {
        boolean bret = false;
        try {
            if (!this.IsConnected()) {
                this.logger_.error("disconnected");
                bret = false;
            } else {
                for (int i = 0; i < this.blockchain_managers_.size(); ++i) {
                    BlockChainManager blockchain_manager = this.blockchain_managers_.get(i);
                    if (!blockchain_manager.IsConnected() || this.SendMessage(blockchain_manager, type, true, blockchain_manager.sequence_, msg)) continue;
                    this.logger_.error("add send queue failed");
                }
                bret = true;
            }
        }
        catch (Exception e) {
            this.logger_.error("add message failed, " + e.getMessage());
        }
        return bret;
    }

    public String GetVersion() {
        String adapter_version = "version: 2.0.0.0.2221";
        return adapter_version;
    }

    private boolean SendMessage(BlockChainManager blockchain_manager, int type, boolean request, long sequence, byte[] data) {
        Common.WsMessage.Builder wsMessage = Common.WsMessage.newBuilder();
        wsMessage.setType(type);
        wsMessage.setRequest(request);
        wsMessage.setSequence(sequence);
        if (data != null) {
            wsMessage.setData(ByteString.copyFrom((byte[])data));
        }
        return blockchain_manager.send_queue_.add(wsMessage.build());
    }

    private class BlockChainManager
    implements Runnable {
        private Thread blockchain_manager_thhead;
        private BlockChain block_chain_;
        private LinkedBlockingQueue<Common.WsMessage> send_queue_;
        private boolean is_exit = true;
        private boolean is_connected_ = false;
        private long sequence_ = 0L;
        private long heartbeat_time_ = 0L;
        private Integer index_ = -1;
        private Draft draft_;
        private URI uri_;

        public BlockChainManager(Integer index, String uri_address) {
            this.index_ = index;
            this.draft_ = new Draft_17();
            this.uri_ = URI.create(uri_address);
            this.send_queue_ = new LinkedBlockingQueue();
            this.blockchain_manager_thhead = new Thread(this);
            this.blockchain_manager_thhead.start();
        }

        @Override
        public void run() {
            if (!this.is_exit) {
                BlockChainAdapter.this.logger_.warn("already running");
                return;
            }
            this.is_exit = false;
            while (!this.is_exit) {
                try {
                    this.block_chain_ = new BlockChain(this.draft_, this.uri_);
                    Thread block_chain_thread = new Thread((Runnable)((Object)this.block_chain_));
                    block_chain_thread.setName("worker_thread_" + this.index_);
                    block_chain_thread.start();
                    block_chain_thread.join();
                }
                catch (Exception e) {
                    BlockChainAdapter.this.logger_.error("connect failed, " + e.getMessage());
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception e) {
                    BlockChainAdapter.this.logger_.error("sleep 5000 failed, " + e.getMessage());
                }
            }
        }

        public boolean IsConnected() {
            return this.is_connected_;
        }

        public void Stop() {
            try {
                this.is_exit = true;
                this.block_chain_.close();
            }
            catch (Exception e) {
                BlockChainAdapter.this.logger_.error("join failed, " + e.getMessage());
            }
        }

        public void Join() {
            try {
                this.blockchain_manager_thhead.join();
            }
            catch (InterruptedException e) {
                BlockChainAdapter.this.logger_.error("BlockChainManager join error, " + e.getMessage());
            }
        }

        private class BlockChain
        extends WebSocketClient {
            private SendMessageThread send_message_thread_;
            private HeartbeatThread heartbeat_thread_;

            public BlockChain(Draft d, URI uri) {
                super(uri, d);
                this.send_message_thread_ = new SendMessageThread("Send Thread");
                this.heartbeat_thread_ = new HeartbeatThread("Heartbeat");
                WebSocketImpl.DEBUG = false;
                BlockChainAdapter.this.AddChainMethod(1, new BlockChainAdapterProc(){

                    @Override
                    public void ChainMethod(byte[] msg, int length) {
                        BlockChain.this.OnRequestPing(msg, length);
                    }
                });
                BlockChainAdapter.this.AddChainResponseMethod(1, new BlockChainAdapterProc(){

                    @Override
                    public void ChainMethod(byte[] msg, int length) {
                        BlockChain.this.OnResponsePing(msg, length);
                    }
                });
            }

            public void onError(Exception ex) {
                BlockChainAdapter.this.logger_.error("Error: " + ex.getMessage());
            }

            public void onOpen(ServerHandshake handshake) {
                BlockChainManager.this.is_connected_ = true;
                BlockChainManager.this.heartbeat_time_ = System.currentTimeMillis();
                BlockChainAdapter.this.logger_.debug("open successful");
            }

            public void onClose(int code, String reason, boolean remote) {
                BlockChainManager.this.is_connected_ = false;
                this.heartbeat_thread_.Stop();
                this.heartbeat_thread_.Join();
                this.send_message_thread_.Stop();
                this.send_message_thread_.Join();
                BlockChainAdapter.this.logger_.warn("Closed: " + BlockChainManager.this.index_ + ", code:" + code + ", reason:" + reason);
            }

            public void onMessage(String message) {
                try {
                    Common.WsMessage wsMessage = Common.WsMessage.parseFrom(ByteString.copyFrom((byte[])message.getBytes()));
                    int type = (int)wsMessage.getType();
                    boolean request = wsMessage.getRequest();
                    if (request && BlockChainAdapter.this.request_handler_[type] != null) {
                        byte[] msg = wsMessage.getData().toByteArray();
                        BlockChainAdapter.this.request_handler_[type].ChainMethod(msg, msg.length);
                    } else if (!request && BlockChainAdapter.this.response_handler_[type] != null) {
                        byte[] msg = wsMessage.getData().toByteArray();
                        BlockChainAdapter.this.response_handler_[type].ChainMethod(msg, msg.length);
                    } else {
                        BlockChainAdapter.this.logger_.warn("onMessage:" + (request ? " request method" : " reponse method") + " (" + type + ")" + " does not exist");
                    }
                }
                catch (Exception e) {
                    BlockChainAdapter.this.logger_.error("onMessage: the message of receive is not WsMessage format");
                }
            }

            public void onMessage(ByteBuffer message) {
                try {
                    Common.WsMessage wsMessage = Common.WsMessage.parseFrom(ByteString.copyFrom((ByteBuffer)message));
                    int type = (int)wsMessage.getType();
                    boolean request = wsMessage.getRequest();
                    if (request && BlockChainAdapter.this.request_handler_[type] != null) {
                        byte[] msg = wsMessage.getData().toByteArray();
                        BlockChainAdapter.this.request_handler_[type].ChainMethod(msg, msg.length);
                    } else if (!request && BlockChainAdapter.this.response_handler_[type] != null) {
                        byte[] msg = wsMessage.getData().toByteArray();
                        BlockChainAdapter.this.response_handler_[type].ChainMethod(msg, msg.length);
                    } else {
                        BlockChainAdapter.this.logger_.warn("onMessage:" + (request ? " request method" : " reponse method") + " (" + type + ")" + " does not exist");
                    }
                }
                catch (Exception e) {
                    BlockChainAdapter.this.logger_.error("the message of receive is not WsMessage format");
                }
            }

            private void OnRequestPing(byte[] msg, int length) {
                WebSocket conn = this.getConnection();
                try {
                    Common.Ping ping = Common.Ping.parseFrom(msg);
                    Common.Pong.Builder pong = Common.Pong.newBuilder();
                    pong.setNonce(ping.getNonce());
                    BlockChainAdapter.this.SendMessage((BlockChainManager)BlockChainAdapter.this.blockchain_managers_.get(BlockChainManager.this.index_), 1, false, BlockChainManager.this.sequence_, pong.build().toByteArray());
                }
                catch (InvalidProtocolBufferException e) {
                    BlockChainAdapter.this.logger_.error("OnRequestPing: parse ping data failed (" + conn.getRemoteSocketAddress().getHostString() + ":" + conn.getRemoteSocketAddress().getPort() + ")");
                }
            }

            private void OnResponsePing(byte[] msg, int length) {
                WebSocket conn = this.getConnection();
                try {
                    Common.Pong.parseFrom(msg);
                    BlockChainManager.this.heartbeat_time_ = System.currentTimeMillis();
                    BlockChainAdapter.this.logger_.debug("OnRequestPing: Recv pong from " + conn.getRemoteSocketAddress().getHostString() + ":" + conn.getRemoteSocketAddress().getPort());
                }
                catch (InvalidProtocolBufferException e) {
                    BlockChainAdapter.this.logger_.error("OnResponsePing: parse pong data failed (" + conn.getRemoteSocketAddress().getHostString() + ":" + conn.getRemoteSocketAddress().getPort() + ")");
                }
            }

            private class SendMessageThread
            implements Runnable {
                private boolean send_enabled_ = true;
                private Thread send_message_thread_ = new Thread(this);

                SendMessageThread(String thread_name) {
                    this.send_message_thread_.setName(thread_name);
                    this.send_message_thread_.start();
                }

                @Override
                public void run() {
                    while (this.send_enabled_) {
                        Common.WsMessage send_message = null;
                        try {
                            if (!BlockChainManager.this.is_connected_) {
                                Thread.sleep(3000L);
                                continue;
                            }
                            send_message = (Common.WsMessage)BlockChainManager.this.send_queue_.take();
                            if (send_message == null) continue;
                            BlockChain.this.send(send_message.toByteArray());
                        }
                        catch (Exception e) {
                            BlockChainAdapter.this.logger_.error("HeartbeatThread send failed, " + e.getMessage());
                            BlockChainManager.this.send_queue_.add(send_message);
                            try {
                                Thread.sleep(3000L);
                            }
                            catch (Exception ex) {
                                BlockChainAdapter.this.logger_.error("HeartbeatThread sleep failed, " + ex.getMessage());
                            }
                        }
                    }
                }

                void Stop() {
                    this.send_enabled_ = false;
                    try {
                        Common.WsMessage.Builder send_message = Common.WsMessage.newBuilder();
                        send_message.setData(ByteString.copyFrom((byte[])"".getBytes()));
                        send_message.setSequence(0L);
                        send_message.setRequest(true);
                        send_message.setType(-1L);
                        BlockChainManager.this.send_queue_.put(send_message.build());
                    }
                    catch (InterruptedException e) {
                        BlockChainAdapter.this.logger_.error("MessageThread Stop Error, " + e.getMessage());
                    }
                }

                void Join() {
                    try {
                        this.send_message_thread_.join();
                    }
                    catch (InterruptedException e) {
                        BlockChainAdapter.this.logger_.error("SendMessageThread join error, " + e.getMessage());
                    }
                }
            }

            private class HeartbeatThread
            implements Runnable {
                private boolean heartbeat_enabled_ = true;
                private Thread heartbeat_message_thread_ = new Thread(this);

                HeartbeatThread(String thread_name) {
                    this.heartbeat_message_thread_.setName(thread_name);
                    this.heartbeat_message_thread_.start();
                }

                @Override
                public void run() {
                    while (this.heartbeat_enabled_) {
                        try {
                            Thread.sleep(15000L);
                        }
                        catch (Exception ex) {
                            BlockChainAdapter.this.logger_.error("HeartbeatThread sleep failed, " + ex.getMessage());
                        }
                        if (!BlockChainManager.this.is_connected_) continue;
                        WebSocket conn = BlockChain.this.getConnection();
                        Common.Ping.Builder ping = Common.Ping.newBuilder();
                        ping.setNonce(System.currentTimeMillis() * 1000L);
                        BlockChainAdapter.this.SendMessage((BlockChainManager)BlockChainAdapter.this.blockchain_managers_.get(BlockChainManager.this.index_), 1, true, BlockChainManager.this.sequence_++, ping.build().toByteArray());
                        BlockChainAdapter.this.logger_.debug("OnRequestPing: Send ping to " + conn.getRemoteSocketAddress().getHostString() + ":" + conn.getRemoteSocketAddress().getPort());
                        long current_time = System.currentTimeMillis();
                        if (current_time - BlockChainManager.this.heartbeat_time_ <= 60000L) continue;
                        BlockChainAdapter.this.logger_.error("connection time out (" + conn.getRemoteSocketAddress().getHostString() + ":" + conn.getRemoteSocketAddress().getPort() + ")");
                        BlockChain.this.close();
                    }
                }

                void Stop() {
                    this.heartbeat_enabled_ = false;
                }

                void Join() {
                    try {
                        this.heartbeat_message_thread_.join();
                    }
                    catch (InterruptedException e) {
                        BlockChainAdapter.this.logger_.error("HeartbeatThread join error, " + e.getMessage());
                    }
                }
            }
        }
    }
}

