/*
 * Decompiled with CFR 0.152.
 */
package cn.bubi.log;

import cn.bubi.common.Constant;
import cn.bubi.common.Tools;
import cn.bubi.crypto.protobuf.Chain;
import cn.bubi.encryption.key.PublicKey;
import cn.bubi.exception.SDKException;
import cn.bubi.exception.SdkError;
import cn.bubi.model.request.operation.LogCreateOperation;
import com.google.protobuf.ByteString;
import java.util.List;

public class LogServiceImpl {
    public static Chain.Operation create(LogCreateOperation logCreateOperation) throws SDKException {
        Chain.Operation.Builder operation;
        try {
            String sourceAddress = logCreateOperation.getSourceAddress();
            if (!Tools.isEmpty(sourceAddress).booleanValue() && !PublicKey.isAddressValid((String)sourceAddress)) {
                throw new SDKException(SdkError.INVALID_SOURCEADDRESS_ERROR);
            }
            String topic = logCreateOperation.getTopic();
            if (Tools.isEmpty(topic).booleanValue() || topic.length() < Constant.LOG_TOPIC_MIN || topic.length() > Constant.LOG_TOPIC_MAX) {
                throw new SDKException(SdkError.INVALID_LOG_TOPIC_ERROR);
            }
            List<String> datas = logCreateOperation.getDatas();
            if (Tools.isEmpty(datas).booleanValue()) {
                throw new SDKException(SdkError.INVALID_LOG_DATA_ERROR);
            }
            for (int i = 0; i < datas.size(); ++i) {
                String data = datas.get(i);
                if (data.length() >= Constant.LOG_EACH_DATA_MIN && data.length() <= Constant.LOG_EACH_DATA_MAX) continue;
                throw new SDKException(SdkError.INVALID_LOG_DATA_ERROR);
            }
            String metadata = logCreateOperation.getMetadata();
            operation = Chain.Operation.newBuilder();
            operation.setType(Chain.Operation.Type.LOG);
            if (!Tools.isEmpty(sourceAddress).booleanValue()) {
                operation.setSourceAddress(sourceAddress);
            }
            if (!Tools.isEmpty(metadata).booleanValue()) {
                operation.setMetadata(ByteString.copyFromUtf8((String)metadata));
            }
            Chain.OperationLog.Builder operationLog = operation.getLogBuilder();
            if (!Tools.isEmpty(sourceAddress).booleanValue()) {
                operation.setSourceAddress(sourceAddress);
            }
            operationLog.setTopic(topic);
            operationLog.addAllDatas(datas);
            if (!Tools.isEmpty(metadata).booleanValue()) {
                logCreateOperation.setMetadata(metadata);
            }
        }
        catch (SDKException sdkException) {
            throw sdkException;
        }
        catch (Exception e) {
            throw new SDKException(SdkError.SYSTEM_ERROR.getCode(), e.getMessage());
        }
        return operation.build();
    }
}

