/*
 * Decompiled with CFR 0.152.
 */
package cn.bubi.token.impl;

import cn.bubi.common.Constant;
import cn.bubi.common.General;
import cn.bubi.common.Tools;
import cn.bubi.crypto.http.HttpKit;
import cn.bubi.crypto.protobuf.Chain;
import cn.bubi.encryption.key.PublicKey;
import cn.bubi.exception.SDKException;
import cn.bubi.exception.SdkError;
import cn.bubi.model.request.AssetGetInfoRequest;
import cn.bubi.model.request.operation.AssetIssueOperation;
import cn.bubi.model.request.operation.AssetSendOperation;
import cn.bubi.model.response.AssetGetInfoResponse;
import cn.bubi.model.response.result.AssetGetInfoResult;
import cn.bubi.token.AssetService;
import com.alibaba.fastjson.JSON;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;

public class AssetServiceImpl
implements AssetService {
    public static Chain.Operation issue(AssetIssueOperation assetIssueOperation) throws SDKException {
        Chain.Operation operation;
        try {
            if (Tools.isEmpty(assetIssueOperation).booleanValue()) {
                throw new SDKException(SdkError.REQUEST_NULL_ERROR);
            }
            String sourceAddress = assetIssueOperation.getSourceAddress();
            if (!Tools.isEmpty(sourceAddress).booleanValue() && !PublicKey.isAddressValid((String)sourceAddress)) {
                throw new SDKException(SdkError.INVALID_SOURCEADDRESS_ERROR);
            }
            String code = assetIssueOperation.getCode();
            if (Tools.isEmpty(code).booleanValue() || (long)code.length() > Constant.ASSET_CODE_MAX) {
                throw new SDKException(SdkError.INVALID_ASSET_CODE_ERROR);
            }
            Long amount = assetIssueOperation.getAmount();
            if (Tools.isEmpty(amount).booleanValue() || amount <= 0L) {
                throw new SDKException(SdkError.INVALID_ISSUE_AMOUNT_ERROR);
            }
            String metadata = assetIssueOperation.getMetadata();
            operation = AssetServiceImpl.buildIssueOperation(sourceAddress, code, amount, metadata);
        }
        catch (SDKException sdkException) {
            throw sdkException;
        }
        catch (Exception e) {
            throw new SDKException(SdkError.SYSTEM_ERROR.getCode(), e.getMessage());
        }
        return operation;
    }

    public static Chain.Operation send(AssetSendOperation assetSendOperation, String transSourceAddress) throws SDKException {
        Chain.Operation operation;
        try {
            boolean isNotValid;
            if (Tools.isEmpty(assetSendOperation).booleanValue()) {
                throw new SDKException(SdkError.REQUEST_NULL_ERROR);
            }
            String sourceAddress = assetSendOperation.getSourceAddress();
            if (!Tools.isEmpty(sourceAddress).booleanValue() && !PublicKey.isAddressValid((String)sourceAddress)) {
                throw new SDKException(SdkError.INVALID_SOURCEADDRESS_ERROR);
            }
            String destAddress = assetSendOperation.getDestAddress();
            if (!PublicKey.isAddressValid((String)destAddress)) {
                throw new SDKException(SdkError.INVALID_DESTADDRESS_ERROR);
            }
            boolean bl = isNotValid = Tools.isEmpty(sourceAddress) == false && sourceAddress.equals(destAddress) || Tools.isEmpty(sourceAddress) != false && transSourceAddress.equals(destAddress);
            if (isNotValid) {
                throw new SDKException(SdkError.SOURCEADDRESS_EQUAL_DESTADDRESS_ERROR);
            }
            String code = assetSendOperation.getCode();
            if (Tools.isEmpty(code).booleanValue() || (long)code.length() > Constant.ASSET_CODE_MAX) {
                throw new SDKException(SdkError.INVALID_ASSET_CODE_ERROR);
            }
            String issuer = assetSendOperation.getIssuer();
            if (!PublicKey.isAddressValid((String)issuer)) {
                throw new SDKException(SdkError.INVALID_ISSUER_ADDRESS_ERROR);
            }
            Long amount = assetSendOperation.getAmount();
            if (Tools.isEmpty(amount).booleanValue() || amount < 1L) {
                throw new SDKException(SdkError.INVALID_ASSET_AMOUNT_ERROR);
            }
            String metadata = assetSendOperation.getMetadata();
            operation = AssetServiceImpl.buildSendOperation(sourceAddress, destAddress, code, issuer, amount, metadata);
        }
        catch (SDKException sdkException) {
            throw sdkException;
        }
        catch (Exception e) {
            throw new SDKException(SdkError.SYSTEM_ERROR.getCode(), e.getMessage());
        }
        return operation;
    }

    @Override
    public AssetGetInfoResponse getInfo(AssetGetInfoRequest assetGetRequest) {
        AssetGetInfoResponse assetGetResponse = new AssetGetInfoResponse();
        AssetGetInfoResult assetGetResult = new AssetGetInfoResult();
        try {
            if (Tools.isEmpty(assetGetRequest).booleanValue()) {
                throw new SDKException(SdkError.REQUEST_NULL_ERROR);
            }
            String address = assetGetRequest.getAddress();
            if (!PublicKey.isAddressValid((String)address)) {
                throw new SDKException(SdkError.INVALID_ADDRESS_ERROR);
            }
            String code = assetGetRequest.getCode();
            if (Tools.isEmpty(code).booleanValue() || (long)code.length() > Constant.ASSET_CODE_MAX) {
                throw new SDKException(SdkError.INVALID_ASSET_CODE_ERROR);
            }
            String issuer = assetGetRequest.getIssuer();
            if (!PublicKey.isAddressValid((String)issuer)) {
                throw new SDKException(SdkError.INVALID_ISSUER_ADDRESS_ERROR);
            }
            if (Tools.isEmpty(General.getInstance().getUrl()).booleanValue()) {
                throw new SDKException(SdkError.URL_EMPTY_ERROR);
            }
            String accountGetInfoUrl = General.getInstance().assetGetUrl(address, code, issuer);
            String result = HttpKit.get(accountGetInfoUrl);
            assetGetResponse = (AssetGetInfoResponse)JSON.parseObject((String)result, AssetGetInfoResponse.class);
            Integer errorCode = assetGetResponse.getErrorCode();
            String errorDesc = assetGetResponse.getErrorDesc();
            if (!Tools.isEmpty(errorCode).booleanValue() && errorCode == 4) {
                throw new SDKException(errorCode, Tools.isEmpty(errorDesc) != false ? "Account (" + address + ") not exist" : errorDesc);
            }
            SdkError.checkErrorCode(assetGetResponse);
            Object[] assetInfos = assetGetResponse.getResult().getAssets();
            if (Tools.isEmpty(assetInfos).booleanValue()) {
                throw new SDKException(SdkError.NO_ASSET_ERROR);
            }
        }
        catch (SDKException sdkException) {
            Integer errorCode = sdkException.getErrorCode();
            String errorDesc = sdkException.getErrorDesc();
            assetGetResponse.buildResponse(errorCode, errorDesc, assetGetResult);
        }
        catch (IOException | KeyManagementException | NoSuchAlgorithmException | NoSuchProviderException e) {
            assetGetResponse.buildResponse(SdkError.CONNECTNETWORK_ERROR, assetGetResult);
        }
        catch (Exception e) {
            e.printStackTrace();
            assetGetResponse.buildResponse(SdkError.SYSTEM_ERROR.getCode(), e.getMessage(), assetGetResult);
        }
        return assetGetResponse;
    }

    public static Chain.Operation buildIssueOperation(String sourceAddress, String code, long amount, String metadata) {
        Chain.Operation.Builder operation = Chain.Operation.newBuilder();
        operation.setType(Chain.Operation.Type.ISSUE_ASSET);
        if (!Tools.isEmpty(sourceAddress).booleanValue()) {
            operation.setSourceAddress(sourceAddress);
        }
        if (!Tools.isEmpty(metadata).booleanValue()) {
            operation.setMetadata(ByteString.copyFromUtf8((String)metadata));
        }
        Chain.OperationIssueAsset.Builder operationIssueAsset = operation.getIssueAssetBuilder();
        operationIssueAsset.setCode(code);
        operationIssueAsset.setAmount(amount);
        return operation.build();
    }

    public static Chain.Operation buildSendOperation(String sourceAddress, String destAddress, String code, String issuer, long amount, String metadata) {
        Chain.Operation.Builder operation = Chain.Operation.newBuilder();
        operation = Chain.Operation.newBuilder();
        operation.setType(Chain.Operation.Type.PAY_ASSET);
        if (!Tools.isEmpty(sourceAddress).booleanValue()) {
            operation.setSourceAddress(sourceAddress);
        }
        if (!Tools.isEmpty(metadata).booleanValue()) {
            operation.setMetadata(ByteString.copyFromUtf8((String)metadata));
        }
        Chain.OperationPayAsset.Builder operationPayAsset = operation.getPayAssetBuilder();
        operationPayAsset.setDestAddress(destAddress);
        Chain.Asset.Builder asset = operationPayAsset.getAssetBuilder();
        Chain.AssetKey.Builder assetKey = asset.getKeyBuilder();
        assetKey.setCode(code);
        assetKey.setIssuer(issuer);
        asset.setAmount(amount);
        return operation.build();
    }
}

