/*
 * Decompiled with CFR 0.152.
 */
package cn.bubi.token.impl;

import cn.bubi.common.Tools;
import cn.bubi.crypto.protobuf.Chain;
import cn.bubi.encryption.key.PublicKey;
import cn.bubi.exception.SDKException;
import cn.bubi.exception.SdkError;
import cn.bubi.model.request.operation.GasSendOperation;
import com.google.protobuf.ByteString;

public class GasServiceImpl {
    public static Chain.Operation send(GasSendOperation gasSendOperation, String transSourceAddress) throws SDKException {
        Chain.Operation.Builder operation;
        try {
            boolean isNotValid;
            String sourceAddress = gasSendOperation.getSourceAddress();
            if (!Tools.isEmpty(sourceAddress).booleanValue() && !PublicKey.isAddressValid((String)sourceAddress)) {
                throw new SDKException(SdkError.INVALID_SOURCEADDRESS_ERROR);
            }
            String destAddress = gasSendOperation.getDestAddress();
            if (!PublicKey.isAddressValid((String)destAddress)) {
                throw new SDKException(SdkError.INVALID_DESTADDRESS_ERROR);
            }
            boolean bl = isNotValid = Tools.isEmpty(sourceAddress) == false && sourceAddress.equals(destAddress) || Tools.isEmpty(sourceAddress) != false && transSourceAddress.equals(destAddress);
            if (isNotValid) {
                throw new SDKException(SdkError.SOURCEADDRESS_EQUAL_DESTADDRESS_ERROR);
            }
            Long amount = gasSendOperation.getAmount();
            if (Tools.isEmpty(amount).booleanValue() || amount < 0L) {
                throw new SDKException(SdkError.INVALID_GAS_AMOUNT_ERROR);
            }
            String metadata = gasSendOperation.getMetadata();
            operation = Chain.Operation.newBuilder();
            operation.setType(Chain.Operation.Type.PAY_COIN);
            if (!Tools.isEmpty(sourceAddress).booleanValue()) {
                operation.setSourceAddress(sourceAddress);
            }
            if (!Tools.isEmpty(metadata).booleanValue()) {
                operation.setMetadata(ByteString.copyFromUtf8((String)metadata));
            }
            Chain.OperationPayCoin.Builder operationPayCoin = operation.getPayCoinBuilder();
            operationPayCoin.setDestAddress(destAddress);
            operationPayCoin.setAmount(amount);
        }
        catch (SDKException sdkException) {
            throw sdkException;
        }
        catch (Exception e) {
            throw new SDKException(SdkError.SYSTEM_ERROR.getCode(), e.getMessage());
        }
        return operation.build();
    }
}

