package org.dromara.zjk.domain;

import org.dromara.common.tenant.core.TenantEntity;
import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.dromara.zjk.annotation.PropertyMsg;
import java.io.Serial;

/**
 * 信用用户管理对象 zjk_credit_user
 *
 * @author ygh
 * @date 2024-11-11
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("zjk_credit_user")
public class ZjkCreditUser extends TenantEntity {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 租户号
     */
    @PropertyMsg(propertyName = "ID")
    private String ID;

    /**
     * 用户id
     */
    @PropertyMsg(propertyName = "user_id")
    private Long userId;

    /**
     * 专家id
     */
    @PropertyMsg(propertyName = "expert_id")
    private Long expertId;

    /**
     * 奖励id
     */
    @PropertyMsg(propertyName = "reward_id")
    private String rewardId;

    /**
     * 奖励内容
     */
    @PropertyMsg(propertyName = "reward_title")
    private String rewardTitle;

    /**
     * 总信用
     */
    @PropertyMsg(propertyName = "point_count")
    private Long creditCount;

    /**
     * 信用变动时间
     */
    @PropertyMsg(propertyName = "change_time")
    private Date changeTime;

    //等级Id
    private Long lvId;


}
