package org.dromara.zjk.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.dromara.common.mybatis.core.domain.BaseEntity;

import java.io.Serial;

/**
 * 专家抽取对象 zjk_expert_item
 *
 * @author ygh
 * @date 2024-10-29
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("zjk_expert_item")
public class ZjkExpertItem extends BaseEntity {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(type = IdType.ASSIGN_ID)
    private Long id;

    /**
     * 专家id数组
     */
    private Long expertId;

    /**
     * 项目id
     */
    private Long itemId;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 部门id
     */
    private Long deptId;


    //    专家请假状态（1：已请假；0：未请假）
    private  String leaveStatus;

    //接受状态（1：已接受；0：未接受）
    private String acceptStatus;

    private Long reviewId;

    private Integer isSure;

    /**
     * 数据来源
    * */
    private Integer isSource;

    //2024/12/03 add字段   抽取状态(0:取消,1:确认,2:重抽)
    private Integer extractionStatus;


    // 短信回复是否是确认  1 确认 0 拒绝
    @TableField(exist = false)
    private Integer smsIsSuer;

    // 确认code
    private String confirmCode;

    // 拒绝code
    private String refuseCode;

}
