package org.dromara.zjk.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.dromara.common.tenant.core.TenantEntity;

import java.io.Serial;
import java.util.Date;

/**
 * 抽取条件对象 zjk_review_phase
 *
 * @author ygh
 * @date 2024-11-01
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("zjk_review_phase")
public class ZjkReviewPhase extends TenantEntity {

    @Serial
    private static final long serialVersionUID = 1L;

    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     *
     */
    private Long revision;

    /**
     * 评审阶段
     */

    private String reviewSn;

    /**
     * 评审时间
     */

    private Date reviewTime;

    /**
     * 评审地点
     */

    private String reviewPlace;

    /**
     * 计划抽取人数
     */

    private Integer plannedIntake;

    /**
     * 抽取方式
     */

    private String extractionMode;

    /**
     * 抽取限制
     */

    private String extractioRestriction;

    /**
     * 回避专家
     */

    private String avoidanceExpert;

    /**
     * 回避单位
     */

    private String avoidanceUnit;

    /*
     * 项目id
     * */
    private Long itemId;

    private Long itemExtreationId;

    /*指定专家*/
    private String designatedNumber;

    private String area;

    private Integer effective;

    private String causeRepum;
    //f父id
    private Long parentId;

    private String extractArea;

    //数据来源
    private Integer source;

    //是否总结
    private Long isSummarize;

    // 确认code
    private String confirmCode;

    // 拒绝code
    private String refuseCode;
    /**
     * 专家确认截至时间
     */
    private Date noticeTime;

}
