package org.dromara.zjk.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import org.dromara.common.mybatis.core.domain.BaseEntity;

import java.math.BigDecimal;

/**
 * 结算凭证
 *
 * @TableName zjk_settlement_voucher
 */
@TableName(value = "zjk_settlement_voucher")
@Data
public class ZjkSettlementVoucher extends BaseEntity {
    /**
     * 租户号
     */
    @TableId(value = "ID", type = IdType.ASSIGN_ID)
    private String id;

    /**
     * 凭证号
     */
    @TableField(value = "voucher_code")
    private String voucherCode;

    /**
     * 项目id
     */
    @TableField(value = "product_id")
    private Long productId;

    /**
     * 专家id
     */
    @TableField(value = "expert_id")
    private Long expertId;

    /**
     * 金额
     */
    @TableField(value = "money")
    private BigDecimal money;

    /**
     * 结算单号
     */
    @TableField(value = "settle_no")
    private String settleNo;

    /**
     * 同步状态;0：未同步；1：已同步
     */
    @TableField(value = "sync_status")
    private Integer syncStatus;

}
