package org.dromara.zjk.domain.bo;

import org.dromara.zjk.domain.LearningBack;
import org.dromara.common.mybatis.core.domain.BaseEntity;
import org.dromara.common.core.validate.AddGroup;
import org.dromara.common.core.validate.EditGroup;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import lombok.EqualsAndHashCode;
import jakarta.validation.constraints.*;

/**
 * 【请填写功能名称】业务对象 zjk_learning_back
 *
 * @author ygh
 * @date 2025-07-28
 */
@Data
@EqualsAndHashCode(callSuper = true)
@AutoMapper(target = LearningBack.class, reverseConvertGenerate = false)
public class LearningBackBo extends BaseEntity {

    /**
     * 租户号
     */
    private String ID;

    /**
     * 反馈名称;zjk_learning_course主键
     */
    @NotBlank(message = "反馈名称;zjk_learning_course主键不能为空", groups = { AddGroup.class, EditGroup.class })
    private String backName;

    /**
     * 反馈内容
     */
    @NotBlank(message = "反馈内容不能为空", groups = { AddGroup.class, EditGroup.class })
    private String backContent;

    private  String expertName;

}
