package org.dromara.zjk.domain.bo;

import org.dromara.zjk.domain.ZjkCreditUser;
import org.dromara.common.mybatis.core.domain.BaseEntity;
import org.dromara.common.core.validate.AddGroup;
import org.dromara.common.core.validate.EditGroup;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import lombok.EqualsAndHashCode;
import jakarta.validation.constraints.*;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 信用用户管理业务对象 zjk_credit_user
 *
 * @author ygh
 * @date 2024-11-11
 */
@Data
@EqualsAndHashCode(callSuper = true)
@AutoMapper(target = ZjkCreditUser.class, reverseConvertGenerate = false)
public class ZjkCreditUserBo extends BaseEntity {

    /**
     * 租户号
     */
    private String ID;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 专家id
     */
    @NotNull(message = "专家id不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long expertId;

    /**
     * 奖励id
     */
    private String rewardId;

    /**
     * 奖励内容
     */
    private String rewardTitle;

    /**
     * 总信用
     */
    private Long creditCount;

    /**
     * 信用变动时间
     */
    private Date changeTime;

    //等级Id
    private Integer lvId;


}
