package org.dromara.zjk.domain.bo;

import io.github.linpeilie.annotations.AutoMapper;
import jakarta.validation.constraints.NotNull;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.dromara.common.mybatis.core.domain.BaseEntity;
import org.dromara.zjk.domain.ZjkExpertItem;

import java.util.Date;

/**
 * 专家项目对应业务对象 zjk_expert_item
 *
 * @author ygh
 * @date 2024-10-29
 */
@Data
@EqualsAndHashCode(callSuper = true)
@AutoMapper(target = ZjkExpertItem.class, reverseConvertGenerate = false)
public class ZjkExpertItemBo extends BaseEntity {

    /**
     * 主键
     */
    @NotNull(message = "主编号不能为空")
    private Long id;

    /**
     *专家id
     */
    private Long expertId;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 部门id
     */
    private Integer deptId;

    /**
     * 项目id
     */
    private Long itemId;

    /*
    * 状态*/
    private Integer extractionStatus;

    /*抽取时间*/
    private Date extractionTime;

    //    专家请假状态（1：已请假；0：未请假）
    private  String leaveStatus;

    //接受状态（1：已接受；0：未接受）
    private String acceptStatus;

    //确认
    private Integer isSure;

    private Long reviewId;
    // 短信回复是否是确认  1 确认 0 拒绝
    private Integer smsIsSuer;

    // 确认code
    private String confirmCode;

    // 拒绝code
    private String refuseCode;



}
