package org.dromara.zjk.domain.bo;

import org.dromara.zjk.domain.ZjkExpertProfessional;
import org.dromara.common.mybatis.core.domain.BaseEntity;
import org.dromara.common.core.validate.AddGroup;
import org.dromara.common.core.validate.EditGroup;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import lombok.EqualsAndHashCode;
import jakarta.validation.constraints.*;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 专家库技术资格关系表业务对象 zjk_expert_professional
 *
 * @author zhangzhou
 * @date 2024-11-01
 */
@Data
@EqualsAndHashCode(callSuper = true)
@AutoMapper(target = ZjkExpertProfessional.class, reverseConvertGenerate = false)
public class ZjkExpertProfessionalBo extends BaseEntity {

    /**
     * id
     */
    @NotNull(message = "id不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long id;

    /**
     * 用户 id
     */
    @NotNull(message = "用户 id不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long userId;

    /**
     * 专家 id
     */
    @NotNull(message = "专家 id不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long expertId;

    /**
     * 技术资格
     */
    @NotBlank(message = "技术资格不能为空", groups = { AddGroup.class, EditGroup.class })
    private String professional;

    /**
     * 技术资格取得时间
     */
    @NotNull(message = "技术资格取得时间不能为空", groups = { AddGroup.class, EditGroup.class })
    private Date professionalDate;

    /**
     * 状态
     */
    @NotNull(message = "状态不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer status;

    /**
     * 备注
     */
    @NotBlank(message = "备注不能为空", groups = { AddGroup.class, EditGroup.class })
    private String remark;


}
