/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.auth.impl.persistence;

import com.alibaba.nacos.persistence.repository.RowMapperManager;
import com.alibaba.nacos.plugin.auth.impl.persistence.PermissionInfo;
import com.alibaba.nacos.plugin.auth.impl.persistence.RoleInfo;
import com.alibaba.nacos.plugin.auth.impl.persistence.User;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.springframework.jdbc.core.RowMapper;

public class AuthRowMapperManager {
    public static final RowMapper<User> USER_ROW_MAPPER = new UserRowMapper();
    public static final RoleInfoRowMapper ROLE_INFO_ROW_MAPPER = new RoleInfoRowMapper();
    public static final PermissionRowMapper PERMISSION_ROW_MAPPER = new PermissionRowMapper();

    static {
        RowMapperManager.registerRowMapper((String)USER_ROW_MAPPER.getClass().getCanonicalName(), USER_ROW_MAPPER);
        RowMapperManager.registerRowMapper((String)ROLE_INFO_ROW_MAPPER.getClass().getCanonicalName(), (RowMapper)ROLE_INFO_ROW_MAPPER);
        RowMapperManager.registerRowMapper((String)PERMISSION_ROW_MAPPER.getClass().getCanonicalName(), (RowMapper)PERMISSION_ROW_MAPPER);
    }

    public static final class PermissionRowMapper
    implements RowMapper<PermissionInfo> {
        public PermissionInfo mapRow(ResultSet rs, int rowNum) throws SQLException {
            PermissionInfo info = new PermissionInfo();
            info.setResource(rs.getString("resource"));
            info.setAction(rs.getString("action"));
            info.setRole(rs.getString("role"));
            return info;
        }
    }

    public static final class RoleInfoRowMapper
    implements RowMapper<RoleInfo> {
        public RoleInfo mapRow(ResultSet rs, int rowNum) throws SQLException {
            RoleInfo roleInfo = new RoleInfo();
            roleInfo.setRole(rs.getString("role"));
            roleInfo.setUsername(rs.getString("username"));
            return roleInfo;
        }
    }

    public static final class UserRowMapper
    implements RowMapper<User> {
        public User mapRow(ResultSet rs, int rowNum) throws SQLException {
            User user = new User();
            user.setUsername(rs.getString("username"));
            user.setPassword(rs.getString("password"));
            return user;
        }
    }
}

