/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.ability.config;

import com.alibaba.nacos.api.ability.constant.AbilityKey;
import com.alibaba.nacos.api.ability.register.impl.ServerAbilities;
import com.alibaba.nacos.common.JustForTest;
import com.alibaba.nacos.common.ability.AbstractAbilityControlManager;
import com.alibaba.nacos.common.ability.discover.NacosAbilityManagerHolder;
import com.alibaba.nacos.common.event.ServerConfigChangeEvent;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.notify.listener.Subscriber;
import com.alibaba.nacos.common.utils.ConcurrentHashSet;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AbilityConfigs
extends Subscriber<ServerConfigChangeEvent> {
    public static final String PREFIX = "nacos.core.ability.";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbilityConfigs.class);
    private final Set<AbilityKey> serverAbilityKeys = new ConcurrentHashSet();
    private AbstractAbilityControlManager abilityHandlerRegistry = NacosAbilityManagerHolder.getInstance();

    public AbilityConfigs() {
        this.serverAbilityKeys.addAll(ServerAbilities.getStaticAbilities().keySet());
        NotifyCenter.registerSubscriber((Subscriber)this);
    }

    public void onEvent(ServerConfigChangeEvent event) {
        HashMap<AbilityKey, Boolean> newValues = new HashMap<AbilityKey, Boolean>(this.serverAbilityKeys.size());
        this.serverAbilityKeys.forEach(abilityKey -> {
            String key = PREFIX + abilityKey.getName();
            try {
                Boolean property = (Boolean)EnvUtil.getProperty((String)key, Boolean.class);
                if (property != null) {
                    newValues.put((AbilityKey)abilityKey, property);
                }
            }
            catch (Exception e) {
                LOGGER.warn("Update ability config from env failed, use old val, ability : {} , because : {}", (Object)key, (Object)e);
            }
        });
        this.refresh(newValues);
    }

    private void refresh(Map<AbilityKey, Boolean> newValues) {
        newValues.forEach((abilityKey, val) -> {
            if (val.booleanValue()) {
                this.abilityHandlerRegistry.enableCurrentNodeAbility(abilityKey);
            } else {
                this.abilityHandlerRegistry.disableCurrentNodeAbility(abilityKey);
            }
        });
    }

    public Class<? extends Event> subscribeType() {
        return ServerConfigChangeEvent.class;
    }

    @JustForTest
    protected Set<AbilityKey> getServerAbilityKeys() {
        return this.serverAbilityKeys;
    }

    @JustForTest
    protected void setAbilityHandlerRegistry(AbstractAbilityControlManager abilityHandlerRegistry) {
        this.abilityHandlerRegistry = abilityHandlerRegistry;
    }
}

