/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.utils;

import com.alibaba.nacos.common.http.HttpUtils;
import com.alibaba.nacos.common.model.RestResult;
import com.alibaba.nacos.common.model.RestResultUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.sys.utils.DiskUtils;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.context.request.async.DeferredResult;
import org.springframework.web.multipart.MultipartFile;

public class WebUtils {
    private static final String ENCODING_KEY = "encoding";
    private static final String COMMA = ",";
    private static final String SEMI = ";";
    private static final String TMP_SUFFIX = ".tmp";

    public static String required(HttpServletRequest req, String key) {
        String value = req.getParameter(key);
        if (StringUtils.isEmpty((String)value)) {
            throw new IllegalArgumentException("Param '" + key + "' is required.");
        }
        String encoding = req.getParameter(ENCODING_KEY);
        return WebUtils.resolveValue(value, encoding);
    }

    public static String optional(HttpServletRequest req, String key, String defaultValue) {
        String value = req.getParameter(key);
        if (StringUtils.isBlank((CharSequence)value)) {
            return defaultValue;
        }
        String encoding = req.getParameter(ENCODING_KEY);
        return WebUtils.resolveValue(value, encoding);
    }

    private static String resolveValue(String value, String encoding) {
        if (StringUtils.isEmpty((String)encoding)) {
            encoding = StandardCharsets.UTF_8.name();
        }
        try {
            value = new String(value.getBytes(StandardCharsets.UTF_8), encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return value.trim();
    }

    private static String resolveValueWithUrlDecode(String value, String encoding) {
        block4: {
            if (StringUtils.isEmpty((String)encoding)) {
                encoding = StandardCharsets.UTF_8.name();
            }
            try {
                value = HttpUtils.decode((String)new String(value.getBytes(StandardCharsets.UTF_8), encoding), (String)encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
            }
            catch (Exception ex) {
                String seq = "URLDecoder";
                if (StringUtils.contains((CharSequence)ex.toString(), (CharSequence)"URLDecoder")) break block4;
                throw ex;
            }
        }
        return value.trim();
    }

    public static String getAcceptEncoding(HttpServletRequest req) {
        String encode = StringUtils.defaultIfEmpty((String)req.getHeader("Accept-Encoding"), (String)StandardCharsets.UTF_8.name());
        encode = encode.contains(COMMA) ? encode.substring(0, encode.indexOf(COMMA)) : encode;
        return encode.contains(SEMI) ? encode.substring(0, encode.indexOf(SEMI)) : encode;
    }

    public static String getUserAgent(HttpServletRequest request) {
        String userAgent = request.getHeader("User-Agent");
        if (StringUtils.isEmpty((String)userAgent)) {
            userAgent = StringUtils.defaultIfEmpty((String)request.getHeader("Client-Version"), (String)"");
        }
        return userAgent;
    }

    public static void response(HttpServletResponse response, String body, int code) throws IOException {
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        response.setContentType("application/json;charset=UTF-8");
        response.getWriter().write(body);
        response.setStatus(code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onFileUpload(MultipartFile multipartFile, Consumer<File> consumer, DeferredResult<RestResult<String>> response) {
        if (Objects.isNull(multipartFile) || multipartFile.isEmpty()) {
            response.setResult((Object)RestResultUtils.failed((String)"File is empty"));
            return;
        }
        File tmpFile = null;
        try {
            tmpFile = DiskUtils.createTmpFile((String)multipartFile.getName(), (String)TMP_SUFFIX);
            multipartFile.transferTo(tmpFile);
            consumer.accept(tmpFile);
        }
        catch (Throwable ex) {
            block5: {
                try {
                    if (response.isSetOrExpired()) break block5;
                    response.setResult((Object)RestResultUtils.failed((String)ex.getMessage()));
                }
                catch (Throwable throwable) {
                    DiskUtils.deleteQuietly(tmpFile);
                    throw throwable;
                }
            }
            DiskUtils.deleteQuietly((File)tmpFile);
        }
        DiskUtils.deleteQuietly((File)tmpFile);
    }

    public static <T> void process(DeferredResult<T> deferredResult, CompletableFuture<T> future, Function<Throwable, T> errorHandler) {
        deferredResult.onTimeout(future::join);
        future.whenComplete((t, throwable) -> {
            if (Objects.nonNull(throwable)) {
                deferredResult.setResult(errorHandler.apply((Throwable)throwable));
                return;
            }
            deferredResult.setResult(t);
        });
    }

    public static <T> void process(DeferredResult<T> deferredResult, CompletableFuture<T> future, Runnable success, Function<Throwable, T> errorHandler) {
        deferredResult.onTimeout(future::join);
        future.whenComplete((t, throwable) -> {
            if (Objects.nonNull(throwable)) {
                deferredResult.setResult(errorHandler.apply((Throwable)throwable));
                return;
            }
            success.run();
            deferredResult.setResult(t);
        });
    }
}

