package org.dromara.zjk.domain;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.dromara.common.mybatis.core.domain.BaseEntity;
import org.dromara.zjk.annotation.PropertyMsg;
import org.dromara.zjk.zwy.annotation.EncryptSensitive;

import java.io.Serial;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 发票对象 zjk_invoice
 *
 * @author mzx
 * @date 2024-12-09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("zjk_invoice")
public class ZjkInvoice extends BaseEntity {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 发票表id
     */
    @PropertyMsg(propertyName = "id")
    @TableId(type = IdType.ASSIGN_ID)
    private Long id;

    /**
     * 发票号码
     */
    @PropertyMsg(propertyName = "invoice_number")
    @ExcelProperty(value = "发票号码")
    private Long invoiceNumber;

    /**
     * 发票金额
     */
    @PropertyMsg(propertyName = "invoice_money")
    @ExcelProperty(value = "发票金额")
    @JsonFormat(shape = JsonFormat.Shape.NUMBER)
    private BigDecimal invoiceMoney;

    /**
     * 开票日期
     */
    @PropertyMsg(propertyName = "start_date")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @DateTimeFormat(value = "yyyy-MM-dd")
    @ExcelProperty(value = "开票日期")
    private Date startDate;

    /**
     * 专家名称
     */
    @PropertyMsg(propertyName = "expert_name")
    @ExcelProperty(value = "专家名称")
    private String expertName;

    /**
     * 联系电话
     */
    @EncryptSensitive
    @PropertyMsg(propertyName = "expert_phone")
    @ExcelProperty(value = "联系电话")
    private String expertPhone;

    /**
     * 专家身份证号
     */
    @PropertyMsg(propertyName = "expert_id_number")
    @ExcelProperty(value = "专家身份证号")
    private String expertIdNumber;

    /**
     * 职称等级
     */
    @PropertyMsg(propertyName = "expert_title_level")
    @ExcelProperty(value = "职称等级")
    private String expertTitleLevel;

    /**
     * 电子发票附件相关 ,存储oss的id
     */
    @PropertyMsg(propertyName = "invoice_attached")
    private String invoiceAttached;

    /**
     * 创建人
     */
    @PropertyMsg(propertyName = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @PropertyMsg(propertyName = "create_time")
    private Date createTime;

    /**
     * 修改人
     */
    @PropertyMsg(propertyName = "update_by")
    private Long updateBy;

    /**
     * 创建时间
     */
    @PropertyMsg(propertyName = "update_time")
    private Date updateTime;

    /**
     * 创建部门
     */
    @PropertyMsg(propertyName = "create_dept")
    private Long createDept;

    /**
     * 租户编码
     */
    @PropertyMsg(propertyName = "tenant_id")
    private String tenantId;
    /**
     * 项目id
     */
    @PropertyMsg(propertyName = "product_id")
    private Long productId;
    /**
     * 项目阶段
     */
    @PropertyMsg(propertyName = "reviewSn")
    private Integer reviewSn;
    /**
     * 结算单id
     */
    @PropertyMsg(propertyName = "settle_id")
    private Long settleId;

    private String hmac;
    /**
     * 审核状态1：已审核
     */
    private Integer checkStatus;
}
