package org.dromara.zjk.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.dromara.common.mybatis.core.domain.BaseEntity;

import java.io.Serial;
import java.util.Date;

/**
 * 专家对象 zjk_item_extreation
 *
 * @author ygh
 * @date 2024-10-29
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("zjk_item_extreation")
public class ZjkItemExtreation extends BaseEntity {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     *主键
     */
    @TableId(type = IdType.ASSIGN_ID)
    private Long id;

    /**
     * 项目id
     */
    private Long itemId;

    /**
     * 专家数量
     */
    private Integer expertSum;

    /**
     * 抽取次数
     */
    private Integer extractionCount;

    /**
     * 已抽取人数
     */
    private Integer extractedSum;

    /**
     * 抽取状态
     */
    private Integer extractionStatus;

    /**
     * 抽取时间
     */
    private Date extractionTime;

    /**
     *抽取人
     */
    private String extractionUser;

    /**
     *抽取流水号
     */
    private String extractionSn;

    private Long reviewId;
    //是否确认
    private Long isSure;
}
