package org.dromara.zjk.domain.bo;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.dromara.zjk.annotation.PropertyMsg;
import org.dromara.zjk.domain.ZjkLearningMaterials;
import org.dromara.common.mybatis.core.domain.BaseEntity;
import org.dromara.common.core.validate.AddGroup;
import org.dromara.common.core.validate.EditGroup;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import lombok.EqualsAndHashCode;
import jakarta.validation.constraints.*;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 【请填写功能名称】业务对象 zjk_learning_materials
 *
 * @author ygh
 * @date 2024-11-26
 */
@Data
@EqualsAndHashCode(callSuper = true)
@AutoMapper(target = ZjkLearningMaterials.class, reverseConvertGenerate = false)
public class ZjkLearningMaterialsBo extends BaseEntity {

    /**
     * 主键
     */
    private Long id;

    /**
     * 资料id
     */
    private String materialsId;

    /**
     * 资料名称
     */
    private String materialsName;

    /**
     * 观看次数
     */
    private String materialsCount;

    /**
     * 状态（0，失效，1.正常）
     */
    private String status;

    /**
    * 开始时间
    * */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startTime;

    /**
     * 结束时间
     * */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endTime;

    /**
    * url地址
    * */
    private String materialsUrl;
}
