package org.dromara.zjk.expert.expertPaper.service;

import org.dromara.common.mybatis.core.page.PageQuery;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.zjk.expert.expertPaper.domain.ZjkExpertPaper;
import org.dromara.zjk.expert.expertPaper.domain.bo.ZjkExpertPaperBo;
import org.dromara.zjk.expert.expertPaper.domain.vo.ZjkExpertPaperVo;

import java.util.Collection;
import java.util.List;

/**
 * 专家论文信息Service接口
 *
 * @author zhangzhou
 * @date 2024-11-10
 */
public interface IZjkExpertPaperService {

    /**
     * 查询专家论文信息
     *
     * @param id 主键
     * @return 专家论文信息
     */
    ZjkExpertPaperVo queryById(Long id);

    /**
     * 分页查询专家论文信息列表
     *
     * @param bo        查询条件
     * @param pageQuery 分页参数
     * @return 专家论文信息分页列表
     */
    TableDataInfo<ZjkExpertPaperVo> queryPageList(ZjkExpertPaperBo bo, PageQuery pageQuery);

    /**
     * 查询符合条件的专家论文信息列表
     *
     * @param bo 查询条件
     * @return 专家论文信息列表
     */
    List<ZjkExpertPaperVo> queryList(ZjkExpertPaperBo bo);

    /**
     * 新增专家论文信息
     *
     * @param bo 专家论文信息
     * @return 是否新增成功
     */
    Boolean insertByBo(ZjkExpertPaperBo bo);

    /**
     * 修改专家论文信息
     *
     * @param bo 专家论文信息
     * @return 是否修改成功
     */
    Boolean updateByBo(ZjkExpertPaperBo bo);

    /**
     * 校验并批量删除专家论文信息信息
     *
     * @param ids     待删除的主键集合
     * @param isValid 是否进行有效性校验
     * @return 是否删除成功
     */
    Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);

    /**
     * 专家 id 进行 新增专家论文信息信息
     * @param zjkExpertPaperList
     * @param expertId
     */
    void handleExpertPapers(List<ZjkExpertPaper> zjkExpertPaperList, Long expertId);


    /**
     * 根据专家 id 获取专家论文信息信息
     * @param expertId
     * @return
     */
    List<ZjkExpertPaper> populateExpertPapersList(Long expertId);


    List<ZjkExpertPaper> selectByExpertId(Long expertId);

    void deleteByProductId(Long productReviewId);

    boolean saveBatch(List<ZjkExpertPaper> zjkExpertPaperList);

    List<ZjkExpertPaper> selectListByProductIds(Long zjkProductReviewId);

    List<ZjkExpertPaperVo> paperList(Long productId, String reviewSn);

    Long getExpertPaperCount();
}
