package org.dromara.zjk.learning_world.domain.bo;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Value;
import org.dromara.common.core.utils.DateUtils;
import org.dromara.zjk.learning_world.domain.entity.ZjkLearningRecords;
import org.dromara.common.mybatis.core.domain.BaseEntity;
import org.dromara.common.core.validate.AddGroup;
import org.dromara.common.core.validate.EditGroup;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import lombok.EqualsAndHashCode;
import jakarta.validation.constraints.*;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 学习记录业务对象 zjk_learning_records
 *
 * @author wt
 * @date 2024-11-26
 */
@Data
@EqualsAndHashCode(callSuper = true)
@AutoMapper(target = ZjkLearningRecords.class, reverseConvertGenerate = false)
public class ZjkLearningRecordsBo extends BaseEntity {

    /**
     * id
     */
    private Long id;

    /**
     * 课程id
     */
    private Long courseId;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 专家id
     */
    private Long expertId;

    /**
     * 视频时长
     */
    @JsonFormat(pattern = "HH:mm:ss",timezone="GMT+8")
    @DateTimeFormat(pattern = "HH:mm:ss")
    private Date rate;

    /**
     * 观看时长
     */
    @JsonFormat(pattern = "HH:mm:ss",timezone="GMT+8")
    @DateTimeFormat(pattern = "HH:mm:ss")
    private Date viewDuration;


    /**
     * 学习时长
     */
    private Long learningSessionLength;

    /**
     * 状态
     */
    private String status;

    /**
     * 备注
     */
    private String remark;


    private String courseName;

    private String expertName;
}
