package org.dromara.zjk.learning_world.domain.entity;

import org.dromara.common.tenant.core.TenantEntity;
import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.dromara.zjk.annotation.PropertyMsg;

import java.io.Serial;
import java.util.Date;

/**
 * 学习工具管理对象 zjk_learning_tool
 *
 * @author ygh
 * @date 2024-11-10
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("zjk_learning_tool")
public class ZjkLearningTool extends TenantEntity {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @PropertyMsg(propertyName = "id")
    private Long id;

    /**
     * 工具名称
     */
    @PropertyMsg(propertyName = "name")
    private String name;

    /**
     * 附件
     */
    @PropertyMsg(propertyName = "attachment")
    private String attachment;

    /**
     * 状态
     */
    @PropertyMsg(propertyName = "status")
    private String status;

    /**
     * 备注
     */
    @PropertyMsg(propertyName = "remark")
    private String remark;

    /**
     * 是否删除
     */
    @TableLogic
    @PropertyMsg(propertyName = "del_flag")
    private Long delFlag;

    /**
     * 操作时间
     */
    @PropertyMsg(propertyName = "takedown_time")
    private Date takedownTime;
    /**
     * 用户id
     */
    @PropertyMsg(propertyName = "user_id")
    private Long userId;
}
