package org.dromara.zjk.service;

import jakarta.validation.constraints.NotNull;
import org.dromara.common.mybatis.core.page.PageQuery;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.zjk.domain.ZjkInvoiceReport;
import com.baomidou.mybatisplus.extension.service.IService;
import org.dromara.zjk.domain.bo.ZjkInvoiceBo;
import org.dromara.zjk.domain.dto.FpReportInQueryDTO;
import org.dromara.zjk.domain.vo.FpReportInVO;
import org.dromara.zjk.domain.vo.ZjkInvoiceReportVO;
import org.dromara.zjk.domain.vo.ZjkInvoiceVo;

import java.util.List;

/**
* @author EDY
* @description 针对表【zjk_invoice_report(发票报表)】的数据库操作Service
* @createDate 2025-07-30 11:02:12
*/
public interface ZjkInvoiceReportService extends IService<ZjkInvoiceReport> {

    TableDataInfo<ZjkInvoiceReportVO> queryPageList(ZjkInvoiceReportVO bo, PageQuery pageQuery);

    TableDataInfo<FpReportInVO> getInfoList(PageQuery pageQuery, FpReportInQueryDTO dto);

    List<FpReportInVO> queryList(FpReportInQueryDTO dto);

    void handleInvoiceReport(Integer type);
}
