package org.dromara.zjk.utils;



import org.dromara.zjk.enums.BaseCodeEnum;
import org.dromara.zjk.enums.BaseEnum;
import org.dromara.zjk.enums.SourceTypeEnum;

import java.util.Objects;

/**
 * 枚举工具类
 * @create 2020-09-24 11:11
 */
public class EnumUtil {


    /**
     * 根据 Value 获取枚举
     */
    public static <T extends BaseEnum> T getEnumByValue(Class<T> clazz, int value){
        for(T _enum : clazz.getEnumConstants()){
            if(value == (int) _enum.getValue()){
                return _enum;
            }
        }

        return null;
    }

    /**
     * 根据 Value 获取name
     */
    public static <T extends BaseEnum> String getNameByValue(Class<T> clazz, Integer value){
        if(value == null || value < 0){
            return "";
        }
        T enumByValue = getEnumByValue(clazz, value);
        if(Objects.equals(null, enumByValue)){
            return "";
        }
        return (String) enumByValue.getName();
    }

    /**
     * 根据 code 获取枚举
     */
    public static <T extends BaseCodeEnum> T getEnumByCode(Class<T> clazz, String code){
        if(code == null || code.equals("")){
            return null;
        }
        for(T _enum : clazz.getEnumConstants()){
            if(code.equals(_enum.getCode())){
                return _enum;
            }
        }
        return null;
    }

    /**
     * 根据 code 获取name
     */
    public static <T extends BaseCodeEnum> String getNameByCode(Class<T> clazz, String code){
        BaseCodeEnum codeEnum = getEnumByCode(clazz, code);
        if(codeEnum == null){
            return "";
        }
        return codeEnum.getName();
    }
}
