/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.controller.v2;

import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.model.RestResult;
import com.alibaba.nacos.common.model.RestResultUtils;
import com.alibaba.nacos.core.distributed.ProtocolManager;
import com.alibaba.nacos.core.distributed.id.IdGeneratorManager;
import com.alibaba.nacos.core.model.request.LogUpdateRequest;
import com.alibaba.nacos.core.model.vo.IdGeneratorVO;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v2/core/ops"})
public class CoreOpsV2Controller {
    private final ProtocolManager protocolManager;
    private final IdGeneratorManager idGeneratorManager;

    public CoreOpsV2Controller(ProtocolManager protocolManager, IdGeneratorManager idGeneratorManager) {
        this.protocolManager = protocolManager;
        this.idGeneratorManager = idGeneratorManager;
    }

    @PostMapping(value={"/raft"})
    @Secured(action=ActionTypes.WRITE, resource="nacos/admin", signType="console")
    public RestResult<String> raftOps(@RequestBody Map<String, String> commands) {
        return this.protocolManager.getCpProtocol().execute(commands);
    }

    @GetMapping(value={"/ids"})
    public RestResult<List<IdGeneratorVO>> ids() {
        ArrayList result = new ArrayList();
        this.idGeneratorManager.getGeneratorMap().forEach((resource, idGenerator) -> {
            IdGeneratorVO vo = new IdGeneratorVO();
            vo.setResource((String)resource);
            IdGeneratorVO.IdInfo info = new IdGeneratorVO.IdInfo();
            info.setCurrentId(idGenerator.currentId());
            info.setWorkerId(idGenerator.workerId());
            vo.setInfo(info);
            result.add(vo);
        });
        return RestResultUtils.success(result);
    }

    @PutMapping(value={"/log"})
    @Secured(action=ActionTypes.WRITE, resource="nacos/admin", signType="console")
    public RestResult<Void> updateLog(@RequestBody LogUpdateRequest logUpdateRequest) {
        Loggers.setLogLevel(logUpdateRequest.getLogName(), logUpdateRequest.getLogLevel());
        return RestResultUtils.success();
    }
}

