/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.tianfu.json.internal.bind;

import com.tongweb.tianfu.json.Json;
import com.tongweb.tianfu.json.TypeAdapter;
import com.tongweb.tianfu.json.internal.bind.ReflectiveTypeAdapterFactory;
import com.tongweb.tianfu.json.reflect.TypeToken;
import com.tongweb.tianfu.json.stream.JsonReader;
import com.tongweb.tianfu.json.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;

final class TypeAdapterRuntimeTypeWrapper<T>
extends TypeAdapter<T> {
    private final Json context;
    private final TypeAdapter<T> delegate;
    private final Type type;

    TypeAdapterRuntimeTypeWrapper(Json context, TypeAdapter<T> delegate, Type type) {
        this.context = context;
        this.delegate = delegate;
        this.type = type;
    }

    @Override
    public T read(JsonReader in) throws IOException {
        return this.delegate.read(in);
    }

    @Override
    public void write(JsonWriter out, T value) throws IOException {
        TypeAdapter<Object> chosen = this.delegate;
        Type runtimeType = this.getRuntimeTypeIfMoreSpecific(this.type, value);
        if (runtimeType != this.type) {
            TypeAdapter<?> runtimeTypeAdapter = this.context.getAdapter(TypeToken.get(runtimeType));
            chosen = !(runtimeTypeAdapter instanceof ReflectiveTypeAdapterFactory.Adapter) ? runtimeTypeAdapter : (!(this.delegate instanceof ReflectiveTypeAdapterFactory.Adapter) ? this.delegate : runtimeTypeAdapter);
        }
        chosen.write(out, value);
    }

    private Type getRuntimeTypeIfMoreSpecific(Type type, Object value) {
        if (value != null && (type == Object.class || type instanceof TypeVariable || type instanceof Class)) {
            type = value.getClass();
        }
        return type;
    }
}

