/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.remote.udp;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.remote.PushCallBack;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.naming.constants.Constants;
import com.alibaba.nacos.naming.misc.GlobalExecutor;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.monitor.MetricsMonitor;
import com.alibaba.nacos.naming.push.v2.NoRequiredRetryException;
import com.alibaba.nacos.naming.remote.udp.AckEntry;
import com.alibaba.nacos.naming.remote.udp.AckPacket;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.springframework.stereotype.Component;

@Component
public class UdpConnector {
    private final ConcurrentMap<String, AckEntry> ackMap = new ConcurrentHashMap<String, AckEntry>();
    private final ConcurrentMap<String, PushCallBack> callbackMap = new ConcurrentHashMap<String, PushCallBack>();
    private final DatagramSocket udpSocket = new DatagramSocket();
    private volatile boolean running = true;

    public UdpConnector() throws SocketException {
        GlobalExecutor.scheduleUdpReceiver(new UdpReceiver());
    }

    public void shutdown() {
        this.running = false;
    }

    public boolean containAck(String ackId) {
        return this.ackMap.containsKey(ackId);
    }

    public void sendData(AckEntry ackEntry) throws NacosException {
        if (null == ackEntry) {
            return;
        }
        try {
            MetricsMonitor.incrementPush();
            this.doSend(ackEntry.getOrigin());
        }
        catch (IOException e) {
            MetricsMonitor.incrementFailPush();
            throw new NacosException(500, "[NACOS-PUSH] push data with exception: ", (Throwable)e);
        }
    }

    public void sendDataWithCallback(AckEntry ackEntry, PushCallBack pushCallBack) {
        if (null == ackEntry) {
            return;
        }
        GlobalExecutor.scheduleUdpSender(new UdpAsyncSender(ackEntry, pushCallBack), 0L, TimeUnit.MILLISECONDS);
    }

    private void doSend(DatagramPacket packet) throws IOException {
        if (!this.udpSocket.isClosed()) {
            this.udpSocket.send(packet);
        }
    }

    private void callbackSuccess(String ackKey) {
        PushCallBack pushCallBack = (PushCallBack)this.callbackMap.remove(ackKey);
        if (null != pushCallBack) {
            pushCallBack.onSuccess();
        }
    }

    private void callbackFailed(String ackKey, Throwable exception) {
        PushCallBack pushCallBack = (PushCallBack)this.callbackMap.remove(ackKey);
        if (null != pushCallBack) {
            pushCallBack.onFail(exception);
        }
    }

    private class UdpReceiver
    implements Runnable {
        private UdpReceiver() {
        }

        @Override
        public void run() {
            while (UdpConnector.this.running) {
                byte[] buffer = new byte[65536];
                DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                try {
                    UdpConnector.this.udpSocket.receive(packet);
                    String json = new String(packet.getData(), 0, packet.getLength(), StandardCharsets.UTF_8).trim();
                    AckPacket ackPacket = (AckPacket)JacksonUtils.toObj((String)json, AckPacket.class);
                    InetSocketAddress socketAddress = (InetSocketAddress)packet.getSocketAddress();
                    String ip = socketAddress.getAddress().getHostAddress();
                    int port = socketAddress.getPort();
                    if (System.nanoTime() - ackPacket.lastRefTime > Constants.ACK_TIMEOUT_NANOS) {
                        Loggers.PUSH.warn("ack takes too long from {} ack json: {}", (Object)packet.getSocketAddress(), (Object)json);
                    }
                    String ackKey = AckEntry.getAckKey(ip, port, ackPacket.lastRefTime);
                    AckEntry ackEntry = (AckEntry)UdpConnector.this.ackMap.remove(ackKey);
                    if (ackEntry == null) {
                        throw new IllegalStateException("unable to find ackEntry for key: " + ackKey + ", ack json: " + json);
                    }
                    UdpConnector.this.callbackSuccess(ackKey);
                }
                catch (Throwable e) {
                    Loggers.PUSH.error("[NACOS-PUSH] error while receiving ack data", e);
                }
            }
        }
    }

    private class UdpRetrySender
    implements Runnable {
        private final AckEntry ackEntry;

        public UdpRetrySender(AckEntry ackEntry) {
            this.ackEntry = ackEntry;
        }

        @Override
        public void run() {
            if (!UdpConnector.this.containAck(this.ackEntry.getKey())) {
                return;
            }
            if (this.ackEntry.getRetryTimes() > 1) {
                Loggers.PUSH.warn("max re-push times reached, retry times {}, key: {}", (Object)this.ackEntry.getRetryTimes(), (Object)this.ackEntry.getKey());
                UdpConnector.this.ackMap.remove(this.ackEntry.getKey());
                UdpConnector.this.callbackFailed(this.ackEntry.getKey(), (Throwable)((Object)new NoRequiredRetryException()));
                return;
            }
            Loggers.PUSH.info("retry to push data, key: " + this.ackEntry.getKey());
            try {
                this.ackEntry.increaseRetryTime();
                UdpConnector.this.doSend(this.ackEntry.getOrigin());
                GlobalExecutor.scheduleRetransmitter(this, Constants.ACK_TIMEOUT_NANOS, TimeUnit.NANOSECONDS);
            }
            catch (Exception e) {
                UdpConnector.this.callbackFailed(this.ackEntry.getKey(), e);
                UdpConnector.this.ackMap.remove(this.ackEntry.getKey());
            }
        }
    }

    private class UdpAsyncSender
    implements Runnable {
        private final AckEntry ackEntry;
        private final PushCallBack callBack;

        public UdpAsyncSender(AckEntry ackEntry, PushCallBack callBack) {
            this.ackEntry = ackEntry;
            this.callBack = callBack;
        }

        @Override
        public void run() {
            try {
                UdpConnector.this.callbackMap.put(this.ackEntry.getKey(), this.callBack);
                UdpConnector.this.ackMap.put(this.ackEntry.getKey(), this.ackEntry);
                Loggers.PUSH.info("send udp packet: " + this.ackEntry.getKey());
                this.ackEntry.increaseRetryTime();
                UdpConnector.this.doSend(this.ackEntry.getOrigin());
                GlobalExecutor.scheduleRetransmitter(new UdpRetrySender(this.ackEntry), Constants.ACK_TIMEOUT_NANOS, TimeUnit.NANOSECONDS);
            }
            catch (Exception e) {
                UdpConnector.this.ackMap.remove(this.ackEntry.getKey());
                UdpConnector.this.callbackMap.remove(this.ackEntry.getKey());
                this.callBack.onFail((Throwable)e);
            }
        }
    }
}

